/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.cache;

import com.stormpath.sdk.cache.CacheConfigurationBuilder;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.cache.CacheManagerBuilder;
import com.stormpath.sdk.cache.Caches;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.cache.CacheManagerFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PropertiesCacheManagerFactory
implements CacheManagerFactory {
    public static final String STORMPATH_CACHE_CONFIG_PREFIX = "stormpath.client.cacheManager.caches.";
    public static final String STORMPATH_CACHE_MANAGER = "stormpath.client.cacheManager";
    public static final String STORMPATH_CACHE_ENABLED = "stormpath.client.cacheManager.enabled";
    public static final String STORMPATH_CACHE_TTI_SUFFIX = ".tti";
    public static final String STORMPATH_CACHE_TTL_SUFFIX = ".ttl";
    public static final String STORMPATH_CACHE_TTI = "stormpath.client.cacheManager.defaultTti";
    public static final String STORMPATH_CACHE_TTL = "stormpath.client.cacheManager.defaultTtl";

    @Override
    public CacheManager createCacheManager(Map<String, String> config) {
        config = config != null ? config : new LinkedHashMap();
        Set keys = config.keySet();
        CacheManagerBuilder builder = Caches.newCacheManager();
        HashMap<String, CacheConfigurationBuilder> regionConfigs = new HashMap<String, CacheConfigurationBuilder>();
        for (Object key : keys) {
            String regionName;
            String value;
            String sKey = (String)key;
            if (STORMPATH_CACHE_MANAGER.equals(sKey)) continue;
            if (STORMPATH_CACHE_ENABLED.equals(sKey)) {
                value = (String)config.get(sKey);
                boolean enabled = true;
                if (Strings.hasText((String)value)) {
                    if ("true".equalsIgnoreCase(value)) {
                        enabled = true;
                    } else if ("false".equalsIgnoreCase(value)) {
                        enabled = false;
                    } else {
                        String msg = "stormpath.client.cacheManager.enabled value must equal true or false";
                        throw new IllegalArgumentException(msg);
                    }
                }
                if (enabled) continue;
                return Caches.newDisabledCacheManager();
            }
            if (STORMPATH_CACHE_TTI.equals(sKey)) {
                value = (String)config.get(sKey);
                long tti = this.parseLong(sKey, value);
                builder.withDefaultTimeToIdle(tti, TimeUnit.MILLISECONDS);
                continue;
            }
            if (STORMPATH_CACHE_TTL.equals(sKey)) {
                value = (String)config.get(sKey);
                long ttl = this.parseLong(sKey, value);
                builder.withDefaultTimeToLive(ttl, TimeUnit.MILLISECONDS);
                continue;
            }
            if (!sKey.startsWith(STORMPATH_CACHE_CONFIG_PREFIX)) continue;
            value = (String)config.get(sKey);
            String suffix = sKey.substring(STORMPATH_CACHE_CONFIG_PREFIX.length());
            long ttl = -1L;
            long tti = -1L;
            if (suffix.endsWith(STORMPATH_CACHE_TTI_SUFFIX)) {
                regionName = suffix.substring(0, suffix.length() - STORMPATH_CACHE_TTI_SUFFIX.length());
                tti = this.parseLong(sKey, value);
            } else if (suffix.endsWith(STORMPATH_CACHE_TTL_SUFFIX)) {
                regionName = suffix.substring(0, suffix.length() - STORMPATH_CACHE_TTL_SUFFIX.length());
                ttl = this.parseLong(sKey, value);
            } else {
                throw new IllegalArgumentException("Unrecognized configuration property [" + sKey + "]. Ensure any " + "configured region specifies either a TTI or TTL or both via " + "the appropriate suffix (.tti or .ttl respectively).");
            }
            CacheConfigurationBuilder ccb = (CacheConfigurationBuilder)regionConfigs.get(regionName);
            if (ccb == null) {
                ccb = Caches.named((String)regionName);
                regionConfigs.put(regionName, ccb);
            }
            if (ttl >= 0L) {
                ccb.withTimeToLive(ttl, TimeUnit.MILLISECONDS);
            }
            if (tti < 0L) continue;
            ccb.withTimeToIdle(tti, TimeUnit.MILLISECONDS);
        }
        for (CacheConfigurationBuilder ccb : regionConfigs.values()) {
            builder.withCache(ccb);
        }
        return builder.build();
    }

    protected long parseLong(String key, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            String msg = "Unable to parse " + key + " value to a long (milliseconds).";
            throw new IllegalArgumentException(msg, e);
        }
    }
}

