/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.client;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyBuilder;
import com.stormpath.sdk.api.ApiKeys;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.client.AuthenticationScheme;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.client.ClientBuilder;
import com.stormpath.sdk.client.Clients;
import com.stormpath.sdk.client.Proxy;
import com.stormpath.sdk.impl.cache.DisabledCacheManager;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.client.ServletContextClientFactory;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigResolver;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class DefaultServletContextClientFactory
implements ServletContextClientFactory {
    public static final String STORMPATH_API_KEY_FILE = "stormpath.client.apiKey.file";
    public static final String STORMPATH_AUTHENTICATION_SCHEME = "stormpath.client.authenticationScheme";
    public static final String STORMPATH_CACHE_MANAGER = "stormpath.client.cacheManager";
    public static final String STORMPATH_PROXY_HOST = "stormpath.client.proxy.host";
    public static final String STORMPATH_PROXY_PORT = "stormpath.client.proxy.port";
    public static final String STORMPATH_PROXY_USERNAME = "stormpath.client.proxy.username";
    public static final String STORMAPTH_PROXY_PASSWORD = "stormpath.client.proxy.password";
    public static final String STORMPATH_APPLICATION_HREF = "stormpath.application.href";
    public static final String STORMPATH_BASEURL = "stormpath.client.baseUrl";
    private Config config;
    private ServletContext servletContext;
    private ConfigResolver configResolver = ConfigResolver.INSTANCE;

    protected Config getConfig() {
        return this.config;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public Client createClient(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext argument cannot be null.");
        this.servletContext = servletContext;
        this.config = this.configResolver.getConfig(servletContext);
        ClientBuilder builder = Clients.builder();
        this.applyBaseUrl(builder);
        this.applyApiKey(builder);
        this.applyProxy(builder);
        this.applyAuthenticationScheme(builder);
        this.applyCacheManager(builder);
        return builder.build();
    }

    protected void applyBaseUrl(ClientBuilder builder) {
        String baseUrl = (String)this.config.get(STORMPATH_BASEURL);
        if (Strings.hasText((String)baseUrl)) {
            builder.setBaseUrl(baseUrl);
        }
    }

    protected void applyCacheManager(ClientBuilder builder) {
        CacheManager cacheManager;
        try {
            cacheManager = (CacheManager)this.config.getInstance(STORMPATH_CACHE_MANAGER);
        }
        catch (ServletException e) {
            String msg = "Unable to get CacheManager instance from Config: " + e.getMessage();
            throw new IllegalStateException(msg, e);
        }
        Assert.notNull((Object)cacheManager, (String)("Configured CacheManager cannot be null.  If you want to disable caching entirely, configure a " + DisabledCacheManager.class.getName() + " instead."));
        builder.setCacheManager(cacheManager);
    }

    protected void applyApiKey(ClientBuilder clientBuilder) {
        ApiKey apiKey = this.createApiKey();
        clientBuilder.setApiKey(apiKey);
    }

    protected ApiKey createApiKey() {
        ApiKeyBuilder apiKeyBuilder = ApiKeys.builder();
        String value = (String)this.config.get("stormpath.client.apiKey.id");
        if (Strings.hasText((String)value)) {
            apiKeyBuilder.setId(value);
        }
        if (Strings.hasText((String)(value = (String)this.config.get("stormpath.client.apiKey.secret")))) {
            apiKeyBuilder.setSecret(value);
        }
        if (Strings.hasText((String)(value = (String)this.config.get(STORMPATH_API_KEY_FILE)))) {
            apiKeyBuilder.setFileLocation(value);
        }
        return apiKeyBuilder.build();
    }

    protected void applyProxy(ClientBuilder builder) {
        String proxyHost = (String)this.config.get(STORMPATH_PROXY_HOST);
        if (!Strings.hasText((String)proxyHost)) {
            return;
        }
        int port = 80;
        String portValue = (String)this.config.get(STORMPATH_PROXY_PORT);
        if (Strings.hasText((String)portValue)) {
            port = Integer.parseInt(portValue);
        }
        String proxyUsername = (String)this.config.get(STORMPATH_PROXY_USERNAME);
        String proxyPassword = (String)this.config.get(STORMAPTH_PROXY_PASSWORD);
        Proxy proxy = Strings.hasText((String)proxyUsername) || Strings.hasText((String)proxyPassword) ? new Proxy(proxyHost, port, proxyUsername, proxyPassword) : new Proxy(proxyHost, port);
        builder.setProxy(proxy);
    }

    protected void applyAuthenticationScheme(ClientBuilder builder) {
        String schemeName = (String)this.config.get(STORMPATH_AUTHENTICATION_SCHEME);
        if (Strings.hasText((String)schemeName)) {
            AuthenticationScheme scheme = AuthenticationScheme.valueOf((String)schemeName.toUpperCase());
            builder.setAuthenticationScheme(scheme);
        }
    }
}

