/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config;

import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.lang.UnknownClassException;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigFactory;
import com.stormpath.sdk.servlet.config.impl.DefaultConfigFactory;
import com.stormpath.sdk.servlet.i18n.MessageContext;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    public static final String CONFIG_FACTORY_CLASS_PARAM_NAME = "stormpathConfigFactoryClass";
    public static final String CONFIG_ATTRIBUTE_NAME = Config.class.getName();
    private static final Logger log = LoggerFactory.getLogger(ConfigLoader.class);

    public Config createConfig(ServletContext servletContext) throws IllegalStateException {
        if (servletContext.getAttribute(CONFIG_ATTRIBUTE_NAME) != null) {
            String msg = "There is already a Stormpath Config instance associated with the current ServletContext.  Check if you have multiple ConfigLoader* definitions in your web.xml or annotation config!";
            throw new IllegalStateException(msg);
        }
        servletContext.log("Initializing Stormpath config instance.");
        log.info("Starting Stormpath config initialization.");
        long startTime = System.currentTimeMillis();
        try {
            Config config = this.doCreateConfig(servletContext);
            servletContext.setAttribute(CONFIG_ATTRIBUTE_NAME, (Object)config);
            servletContext.setAttribute(MessageContext.class.getName(), (Object)config.getMessageContext());
            if (config.isStormpathEnabled()) {
                log.debug("Published Config as ServletContext attribute with name [{}]", (Object)CONFIG_ATTRIBUTE_NAME);
                if (log.isInfoEnabled()) {
                    long elapsed = System.currentTimeMillis() - startTime;
                    log.info("Stormpath config initialized in {} ms.", (Object)elapsed);
                }
            } else {
                log.info("Stormpath disabled, cancelling initialization.");
            }
            return config;
        }
        catch (RuntimeException ex) {
            log.error("Stormpath config initialization failed", (Throwable)ex);
            servletContext.setAttribute(CONFIG_ATTRIBUTE_NAME, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            log.error("Stormpath config initialization failed", (Throwable)err);
            servletContext.setAttribute(CONFIG_ATTRIBUTE_NAME, (Object)err);
            throw err;
        }
    }

    protected Class<?> determineConfigFactoryClass(ServletContext servletContext) {
        String className = servletContext.getInitParameter(CONFIG_FACTORY_CLASS_PARAM_NAME);
        if ((className = Strings.trimWhitespace((String)className)) != null) {
            try {
                return Classes.forName((String)className);
            }
            catch (UnknownClassException ex) {
                throw new IllegalStateException("Failed to load custom ConfigFactory class [" + className + "]", ex);
            }
        }
        return DefaultConfigFactory.class;
    }

    protected Config doCreateConfig(ServletContext sc) {
        Class<?> clazz = this.determineConfigFactoryClass(sc);
        if (!ConfigFactory.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Custom ConfigFactory class [" + clazz.getName() + "] is not of required type [" + ConfigFactory.class.getName() + "]");
        }
        ConfigFactory factory = (ConfigFactory)Classes.newInstance(clazz);
        return factory.createConfig(sc);
    }

    public void destroyConfig(ServletContext servletContext) {
        servletContext.log("Cleaning up Stormpath config.");
        servletContext.removeAttribute(CONFIG_ATTRIBUTE_NAME);
        servletContext.removeAttribute(MessageContext.class.getName());
    }
}

