/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.lang.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterEnabledPredicate
implements BiPredicate<Boolean, Application> {
    private static final Logger log = LoggerFactory.getLogger(RegisterEnabledPredicate.class);
    private boolean warned = false;

    public boolean test(Boolean stormpathWebRegisterEnabled, Application application) {
        boolean hasDefaultAccountStore;
        if (!stormpathWebRegisterEnabled.booleanValue()) {
            return false;
        }
        boolean bl = hasDefaultAccountStore = application.getDefaultAccountStore() != null;
        if (!hasDefaultAccountStore) {
            if (!this.warned && log.isWarnEnabled()) {
                String msg = "stormpath.web.register.enabled = true, but the application does not have anywhere to save new accounts: the application has not been assigned a default account store (either a Directory, Group or Organization).  You must specify the default account store where your application's newly created accounts will be reside.  As a result, registration will be disabled until an account store is assigned as the application's default account store (you can do this via the REST API or in the Stormpath Administration console).";
                log.warn(msg);
                this.warned = true;
            }
        } else {
            this.warned = false;
        }
        return hasDefaultAccountStore;
    }
}

