/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.filter;

import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.filter.FilterFactory;
import com.stormpath.sdk.servlet.filter.AccessControlFilter;
import com.stormpath.sdk.servlet.filter.UnauthenticatedHandler;
import com.stormpath.sdk.servlet.filter.UnauthorizedHandler;
import javax.servlet.ServletContext;

public abstract class AccessControlFilterFactory<T extends AccessControlFilter>
extends FilterFactory<T> {
    protected static final String UNAUTHENTICATED_HANDLER = "stormpath.web.authc.unauthenticatedHandler";
    protected static final String UNAUTHORIZED_HANDLER = "stormpath.web.authz.unauthorizedHandler";

    @Override
    protected T createInstance(ServletContext servletContext, Config config) throws Exception {
        T f = this.newInstance();
        ((AccessControlFilter)f).setLoginUrl(config.getLoginConfig().getUri());
        ((AccessControlFilter)f).setAccessTokenUrl(config.getAccessTokenUrl());
        UnauthenticatedHandler authc = (UnauthenticatedHandler)config.getInstance(UNAUTHENTICATED_HANDLER);
        ((AccessControlFilter)f).setUnauthenticatedHandler(authc);
        UnauthorizedHandler authz = (UnauthorizedHandler)config.getInstance(UNAUTHORIZED_HANDLER);
        ((AccessControlFilter)f).setUnauthorizedHandler(authz);
        this.configure(f, config);
        return f;
    }

    protected abstract void configure(T var1, Config var2);

    protected abstract T newInstance();
}

