/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.filter;

import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.config.filter.DefaultFilterChainManagerConfigurer;
import com.stormpath.sdk.servlet.filter.DefaultFilter;
import com.stormpath.sdk.servlet.filter.DefaultFilterChainManager;
import com.stormpath.sdk.servlet.filter.FilterChainManager;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChainManagerFactory
extends ConfigSingletonFactory<FilterChainManager> {
    private static final Logger log = LoggerFactory.getLogger(FilterChainManagerFactory.class);
    public static final String FILTER_CONFIG_PREFIX = "stormpath.web.filters.";

    @Override
    protected FilterChainManager createInstance(ServletContext servletContext) throws Exception {
        Config config = this.getConfig();
        DefaultFilterChainManager mgr = new DefaultFilterChainManager(servletContext);
        if (config.isStormpathWebEnabled()) {
            for (DefaultFilter defaultFilter : DefaultFilter.values()) {
                Class<? extends ConfigSingletonFactory<? extends Filter>> o = defaultFilter.getFactoryClass();
                if (o == null) {
                    o = defaultFilter.getFilterClass();
                }
                mgr.addFilter(defaultFilter.name(), o);
            }
            for (String key : config.keySet()) {
                String instanceName;
                int i;
                if (!key.startsWith(FILTER_CONFIG_PREFIX) || (i = (instanceName = key.substring(FILTER_CONFIG_PREFIX.length())).indexOf(46)) >= 0) continue;
                String className = (String)config.get(key);
                Object instance = Classes.newInstance((String)className);
                mgr.addFilter(instanceName, instance);
            }
        } else {
            log.warn("Stormpath web support disabled, filters not added.");
        }
        return new DefaultFilterChainManagerConfigurer(mgr, servletContext, config).configure();
    }
}

