/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.filter;

import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigResolver;
import com.stormpath.sdk.servlet.filter.FilterChainResolver;
import com.stormpath.sdk.servlet.filter.StormpathFilter;
import com.stormpath.sdk.servlet.filter.WrappedServletRequestFactory;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfConfiguredStormpathFilter
extends StormpathFilter {
    private static final Logger log = LoggerFactory.getLogger(SelfConfiguredStormpathFilter.class);

    @Override
    protected void onInit() throws ServletException {
        try {
            this.doInit();
            if (this.isEnabled()) {
                super.onInit();
            }
        }
        catch (ServletException e) {
            log.error("Unable to initialize StormpathFilter.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to initialize StormpathFilter: " + e.getMessage();
            log.error(msg, (Throwable)e);
            throw new ServletException(msg);
        }
    }

    protected void doInit() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        Config config = ConfigResolver.INSTANCE.getConfig(servletContext);
        this.setEnabled(config.isStormpathWebEnabled());
        if (this.isEnabled()) {
            String[] vals;
            this.setClient(config.getClient());
            this.setApplication(config.getApplicationResolver().getApplication(servletContext));
            FilterChainResolver resolver = (FilterChainResolver)config.getInstance("stormpath.web.filter.chain.resolver");
            this.setFilterChainResolver(resolver);
            String val = (String)config.get("stormpath.web.request.client.attributeNames");
            if (Strings.hasText((String)val)) {
                vals = Strings.split((String)val);
                this.setClientRequestAttributeNames(new LinkedHashSet<String>(Arrays.asList(vals)));
            }
            if (Strings.hasText((String)(val = (String)config.get("stormpath.web.request.application.attributeNames")))) {
                vals = Strings.split((String)val);
                this.setApplicationRequestAttributeNames(new LinkedHashSet<String>(Arrays.asList(vals)));
            }
            WrappedServletRequestFactory factory = (WrappedServletRequestFactory)config.getInstance("stormpath.web.request.factory");
            this.setWrappedServletRequestFactory(factory);
        }
    }
}

