/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.impl;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.config.CookieConfig;
import com.stormpath.sdk.servlet.config.CookieProperties;
import com.stormpath.sdk.servlet.config.impl.ConfigReader;

public abstract class AbstractCookieConfig
implements CookieConfig {
    protected static final String NAME = "name";
    protected static final String COMMENT = "comment";
    protected static final String DOMAIN = "domain";
    protected static final String PATH = "path";
    protected static final String SECURE = "secure";
    protected static final String HTTP_ONLY = "httpOnly";
    protected final String name;
    protected final String comment;
    protected final String domain;
    protected final String path;
    protected final boolean secure;
    protected final boolean httpOnly;

    protected abstract String configPrefix();

    public AbstractCookieConfig(ConfigReader configReader) {
        Assert.notNull((Object)configReader);
        this.name = configReader.getString(this.configKeyFor(NAME));
        Assert.hasText((String)this.name, (String)"name cannot be null or empty.");
        this.comment = configReader.getString(this.configKeyFor(COMMENT));
        this.domain = configReader.getString(this.configKeyFor(DOMAIN));
        this.path = configReader.getString(this.configKeyFor(PATH));
        this.secure = configReader.getBoolean(this.configKeyFor(SECURE));
        this.httpOnly = configReader.getBoolean(this.configKeyFor(HTTP_ONLY));
    }

    public AbstractCookieConfig(String name, String comment, String domain, String path, boolean secure, boolean httpOnly) {
        this.name = name;
        Assert.hasText((String)this.name, (String)"name cannot be null or empty.");
        this.comment = comment;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }

    public AbstractCookieConfig(CookieProperties cookieProperties) {
        this(cookieProperties.getCookieName(), cookieProperties.getCookieComment(), cookieProperties.getCookieDomain(), cookieProperties.getCookiePath(), cookieProperties.isCookieSecure(), cookieProperties.isCookieHttpOnly());
    }

    protected String configKeyFor(String propertyName) {
        return this.configPrefix() + "." + propertyName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public int getMaxAge() {
        return -1;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }
}

