/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.impl;

import com.stormpath.sdk.impl.config.DefaultEnvVarNameConverter;
import com.stormpath.sdk.impl.config.EnvVarNameConverter;
import com.stormpath.sdk.impl.config.EnvironmentVariablesPropertiesSource;
import com.stormpath.sdk.impl.config.FilteredPropertiesSource;
import com.stormpath.sdk.impl.config.JSONPropertiesSource;
import com.stormpath.sdk.impl.config.OptionalPropertiesSource;
import com.stormpath.sdk.impl.config.PropertiesSource;
import com.stormpath.sdk.impl.config.ResourcePropertiesSource;
import com.stormpath.sdk.impl.config.SystemPropertiesSource;
import com.stormpath.sdk.impl.config.YAMLPropertiesSource;
import com.stormpath.sdk.impl.io.Resource;
import com.stormpath.sdk.impl.io.StringResource;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigFactory;
import com.stormpath.sdk.servlet.config.impl.DefaultConfig;
import com.stormpath.sdk.servlet.io.ServletContainerResourceFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.ServletContext;

public class DefaultConfigFactory
implements ConfigFactory {
    public static final String STORMPATH_PROPERTIES = "stormpath.properties";
    public static final String STORMPATH_PROPERTIES_SOURCES = "stormpath.properties.sources";
    public static final String ENVVARS_TOKEN = "envvars";
    public static final String SYSPROPS_TOKEN = "sysprops";
    public static final String CONTEXT_PARAM_TOKEN = "contextParam";
    private static final String NL = "\n";
    private static final String REQUIRED_TOKEN = "(required)";
    public static final String DEFAULT_STORMPATH_PROPERTIES_SOURCES = "classpath:com/stormpath/sdk/servlet/config/web.stormpath.properties\nclasspath:stormpath.properties\n/WEB-INF/stormpath.properties\ncontextParam\nenvvars\nsysprops";
    private static final EnvVarNameConverter envVarNameConverter = new DefaultEnvVarNameConverter();

    @Override
    public Config createConfig(ServletContext servletContext) {
        ServletContainerResourceFactory resourceFactory = new ServletContainerResourceFactory(servletContext);
        String sourceDefs = servletContext.getInitParameter(STORMPATH_PROPERTIES_SOURCES);
        if (!Strings.hasText((String)sourceDefs)) {
            sourceDefs = DEFAULT_STORMPATH_PROPERTIES_SOURCES;
        }
        ArrayList<Object> sources = new ArrayList<Object>();
        Scanner scanner = new Scanner(sourceDefs);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            line = Strings.trimWhitespace((String)line);
            boolean required = false;
            int n = line.lastIndexOf(REQUIRED_TOKEN);
            if (n > 0) {
                required = true;
                line = line.substring(0, n);
                line = Strings.trimWhitespace((String)line);
            }
            if (ENVVARS_TOKEN.equalsIgnoreCase(line)) {
                sources.add(new FilteredPropertiesSource((PropertiesSource)new EnvironmentVariablesPropertiesSource(), new FilteredPropertiesSource.Filter(){

                    public String[] map(String key, String value) {
                        if (key.startsWith("STORMPATH_")) {
                            key = envVarNameConverter.toDottedPropertyName(key);
                            return new String[]{key, value};
                        }
                        return null;
                    }
                }));
                continue;
            }
            if (SYSPROPS_TOKEN.equalsIgnoreCase(line)) {
                sources.add(new FilteredPropertiesSource((PropertiesSource)new SystemPropertiesSource(), new FilteredPropertiesSource.Filter(){

                    public String[] map(String key, String value) {
                        if (key.startsWith("stormpath.")) {
                            return new String[]{key, value};
                        }
                        return null;
                    }
                }));
                continue;
            }
            if (CONTEXT_PARAM_TOKEN.equalsIgnoreCase(line)) {
                String value = servletContext.getInitParameter(STORMPATH_PROPERTIES);
                if (!Strings.hasText((String)value)) continue;
                sources.add(new ResourcePropertiesSource((Resource)new StringResource(value)));
                continue;
            }
            Resource resource = resourceFactory.createResource(line);
            ResourcePropertiesSource propertiesSource = new ResourcePropertiesSource(resource);
            if (!required) {
                propertiesSource = new OptionalPropertiesSource((PropertiesSource)propertiesSource);
            }
            sources.add(propertiesSource);
            if (!line.contains(".properties")) continue;
            String jsonFile = line.replace(".properties", ".json");
            resource = resourceFactory.createResource(jsonFile);
            propertiesSource = new JSONPropertiesSource(resource);
            if (!required) {
                propertiesSource = new OptionalPropertiesSource((PropertiesSource)propertiesSource);
            }
            sources.add(propertiesSource);
            String yamlFile = line.replace(".properties", ".yaml");
            resource = resourceFactory.createResource(yamlFile);
            propertiesSource = new YAMLPropertiesSource(resource);
            if (!required) {
                propertiesSource = new OptionalPropertiesSource((PropertiesSource)propertiesSource);
            }
            sources.add(propertiesSource);
            yamlFile = line.replace(".properties", ".yml");
            resource = resourceFactory.createResource(yamlFile);
            propertiesSource = new YAMLPropertiesSource(resource);
            if (!required) {
                propertiesSource = new OptionalPropertiesSource((PropertiesSource)propertiesSource);
            }
            sources.add(propertiesSource);
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (PropertiesSource propertiesSource : sources) {
            Map srcProps = propertiesSource.getProperties();
            props.putAll(srcProps);
        }
        return new DefaultConfig(servletContext, props);
    }
}

