/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.csrf.config;

import com.stormpath.sdk.cache.Cache;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.client.ClientResolver;
import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.csrf.CsrfTokenManager;
import com.stormpath.sdk.servlet.csrf.DefaultCsrfTokenManager;
import javax.servlet.ServletContext;

public class CsrfTokenManagerFactory
extends ConfigSingletonFactory<CsrfTokenManager> {
    public static final String CSRF_TOKEN_NAME = "stormpath.web.csrf.token.name";
    public static final String CSRF_TOKEN_TTL = "stormpath.web.csrf.token.ttl";
    public static final String NONCE_CACHE_NAME = "stormpath.web.nonce.cache.name";

    @Override
    protected CsrfTokenManager createInstance(ServletContext servletContext) throws Exception {
        long ttlMillis;
        String ttlString = (String)this.getConfig().get(CSRF_TOKEN_TTL);
        try {
            ttlMillis = Long.parseLong(ttlString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("stormpath.web.csrf.token.ttl config value must be a long.", e);
        }
        String usedNonceCacheName = (String)this.getConfig().get(NONCE_CACHE_NAME);
        Assert.hasText((String)usedNonceCacheName, (String)"stormpath.web.nonce.cache.name config value is required.");
        Client client = ClientResolver.INSTANCE.getClient(servletContext);
        CacheManager cacheManager = client.getCacheManager();
        Cache usedNonceCache = cacheManager.getCache(usedNonceCacheName);
        String signingKey = client.getApiKey().getSecret();
        String tokenName = (String)this.getConfig().get(CSRF_TOKEN_NAME);
        return new DefaultCsrfTokenManager(tokenName, (Cache<String, String>)usedNonceCache, signingKey, ttlMillis);
    }
}

