/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.event;

import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.oauth.AccessToken;
import com.stormpath.sdk.oauth.RefreshToken;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.account.event.RegisteredAccountRequestEvent;
import com.stormpath.sdk.servlet.account.event.VerifiedAccountRequestEvent;
import com.stormpath.sdk.servlet.authc.FailedAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.LogoutRequestEvent;
import com.stormpath.sdk.servlet.authc.SuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.client.ClientResolver;
import com.stormpath.sdk.servlet.event.RequestEventListener;
import com.stormpath.sdk.servlet.http.CookieResolver;
import com.stormpath.sdk.servlet.oauth.impl.JwtTokenSigningKeyResolver;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.LinkedHashMap;
import javax.servlet.ServletRequest;
import org.apache.oltu.oauth2.rs.extractor.BearerHeaderTokenExtractor;
import org.apache.oltu.oauth2.rs.extractor.TokenExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRevocationRequestEventListener
implements RequestEventListener {
    private static final Logger log = LoggerFactory.getLogger(TokenRevocationRequestEventListener.class);
    private final TokenExtractor tokenExtractor = new BearerHeaderTokenExtractor();
    private final CookieResolver accessTokenCookieResolver = new CookieResolver("access_token");
    private final JwtTokenSigningKeyResolver jwtTokenSigningKeyResolver = new JwtTokenSigningKeyResolver();
    private Client client = null;

    @Override
    public void on(SuccessfulAuthenticationRequestEvent event) {
    }

    @Override
    public void on(FailedAuthenticationRequestEvent event) {
    }

    @Override
    public void on(RegisteredAccountRequestEvent event) {
    }

    @Override
    public void on(VerifiedAccountRequestEvent event) {
    }

    @Override
    public void on(LogoutRequestEvent event) {
        String jwt = this.getJwtFromLogoutRequestEvent(event);
        if (jwt != null) {
            if (this.client == null) {
                this.client = ClientResolver.INSTANCE.getClient((ServletRequest)event.getRequest());
            }
            Key signingKey = this.jwtTokenSigningKeyResolver.getSigningKey(event.getRequest(), event.getResponse(), null, SignatureAlgorithm.HS256);
            JwsHeader header = (JwsHeader)Jwts.parser().setSigningKey(signingKey.getEncoded()).parseClaimsJws(jwt).getHeader();
            Claims claims = (Claims)Jwts.parser().setSigningKey(signingKey.getEncoded()).parseClaimsJws(jwt).getBody();
            if (this.isAccessToken(header)) {
                this.gracefullyDeleteRefreshToken((String)claims.get((Object)"rti"));
                this.gracefullyDeleteAccessToken(claims.getId());
            }
            log.debug("The current access and refresh tokens for '{}' have been revoked.", (Object)(event.getAccount() != null ? event.getAccount().getEmail() : "unknown user"));
        }
    }

    private String getJwtFromLogoutRequestEvent(LogoutRequestEvent event) {
        String jwt = this.tokenExtractor.getAccessToken(event.getRequest());
        if (jwt == null && this.accessTokenCookieResolver.get(event.getRequest(), null) != null) {
            jwt = this.accessTokenCookieResolver.get(event.getRequest(), null).getValue();
        }
        return jwt;
    }

    private boolean isAccessToken(JwsHeader header) {
        return header.get((Object)"stt").equals("access");
    }

    private void gracefullyDeleteAccessToken(String accessTokenId) {
        try {
            String href = "/accessTokens/" + accessTokenId;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("href", href);
            AccessToken accessToken = (AccessToken)((InternalDataStore)this.client.getDataStore()).instantiate(AccessToken.class, map, true);
            accessToken.delete();
        }
        catch (ResourceException e) {
            log.warn("There was an error trying to delete access token with ID {}", (Object)accessTokenId, (Object)e);
        }
    }

    private void gracefullyDeleteRefreshToken(String refreshTokenId) {
        try {
            String href = "/refreshTokens/" + refreshTokenId;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("href", href);
            RefreshToken refreshToken = (RefreshToken)((InternalDataStore)this.client.getDataStore()).instantiate(RefreshToken.class, map, true);
            refreshToken.delete();
        }
        catch (ResourceException e) {
            log.warn("There was an error trying to delete refresh token with ID {}", (Object)refreshTokenId, (Object)e);
        }
    }
}

