/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.HttpFilter;
import com.stormpath.sdk.servlet.filter.UnauthenticatedHandler;
import com.stormpath.sdk.servlet.filter.UnauthorizedHandler;
import com.stormpath.sdk.servlet.util.ServletUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AccessControlFilter
extends HttpFilter {
    private String loginUrl;
    private String accessTokenUrl;
    private UnauthenticatedHandler unauthenticatedHandler;
    private UnauthorizedHandler unauthorizedHandler;

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public void setUnauthenticatedHandler(UnauthenticatedHandler unauthenticatedHandler) {
        this.unauthenticatedHandler = unauthenticatedHandler;
    }

    public void setUnauthorizedHandler(UnauthorizedHandler unauthorizedHandler) {
        this.unauthorizedHandler = unauthorizedHandler;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        Assert.hasText((String)this.loginUrl, (String)"loginUrl cannot be null or empty.");
        Assert.hasText((String)this.accessTokenUrl, (String)"accessTokenUrl cannot be null or empty.");
        Assert.notNull((Object)this.unauthenticatedHandler, (String)"unauthenticatedHandler cannot be null.");
        Assert.notNull((Object)this.unauthorizedHandler, (String)"unauthorizedHandler cannot be null.");
    }

    public UnauthenticatedHandler getUnauthenticatedHandler() {
        return this.unauthenticatedHandler;
    }

    public UnauthorizedHandler getUnauthorizedHandler() {
        return this.unauthorizedHandler;
    }

    protected abstract boolean isAccessAllowed(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    protected abstract boolean onAccessDenied(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    @Override
    protected boolean isContinue(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.isAccessAllowed(request, response) || this.onAccessDenied(request, response);
    }

    protected boolean isLoginRequest(HttpServletRequest request) {
        String contextRelativeUri = ServletUtils.getContextRelativeUri(request);
        return this.loginUrl.equals(contextRelativeUri) || this.accessTokenUrl.equals(contextRelativeUri);
    }
}

