/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.servlet.filter.ContentNegotiationResolver;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.UnresolvedMediaTypeException;
import com.stormpath.sdk.servlet.http.UserAgent;
import com.stormpath.sdk.servlet.http.UserAgents;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultContentNegotiationResolver
implements ContentNegotiationResolver {
    @Override
    public MediaType getContentType(HttpServletRequest request, HttpServletResponse response, List<MediaType> producesMediaTypes) throws UnresolvedMediaTypeException {
        UserAgent ua = UserAgents.get(request);
        List<MediaType> preferredMediaTypes = ua.getAcceptedMediaTypes();
        if (preferredMediaTypes.size() == 0 || preferredMediaTypes.get(0).equals(MediaType.ALL)) {
            return producesMediaTypes.get(0);
        }
        if (ua.isJsonPreferred() && producesMediaTypes.contains(MediaType.APPLICATION_JSON)) {
            return MediaType.APPLICATION_JSON;
        }
        if (ua.isHtmlPreferred() && producesMediaTypes.contains(MediaType.TEXT_HTML)) {
            return MediaType.TEXT_HTML;
        }
        if (request.getHeader("accept").contains("application/x-www-form-urlencoded")) {
            return MediaType.APPLICATION_JSON;
        }
        throw new UnresolvedMediaTypeException(preferredMediaTypes, producesMediaTypes, "The ContentNegotiationResolver was not able to come up with a valid MediaType.");
    }
}

