/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.Factory;
import com.stormpath.sdk.servlet.filter.FilterBuilder;
import com.stormpath.sdk.servlet.filter.FilterChainManager;
import com.stormpath.sdk.servlet.filter.Filters;
import com.stormpath.sdk.servlet.filter.ProxiedFilterChain;
import com.stormpath.sdk.servlet.util.ServletContextInitializable;
import io.jsonwebtoken.lang.Classes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilterChainManager
implements FilterChainManager {
    private static final transient Logger log = LoggerFactory.getLogger(DefaultFilterChainManager.class);
    private final ServletContext servletContext;
    private final Map<String, List<Filter>> filterChains;
    private final Map<String, Object> configuredFilters;

    public DefaultFilterChainManager(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext argument cannot be null.");
        this.servletContext = servletContext;
        this.filterChains = new LinkedHashMap<String, List<Filter>>();
        this.configuredFilters = new LinkedHashMap<String, Object>();
    }

    public void addFilterClasses(Map<String, Class<? extends Filter>> classes) {
        if (Collections.isEmpty(classes)) {
            return;
        }
        this.configuredFilters.putAll(classes);
    }

    public void addFilter(String name, Object filteryThing) {
        if (filteryThing instanceof Class) {
            Assert.isTrue((!Filter.class.equals(filteryThing) ? 1 : 0) != 0, (String)"Cannot specify the Filter class directly.  Specify a class that implements the Filter interface.");
        }
        this.configuredFilters.put(name, filteryThing);
    }

    protected Filter createFilter(String name, String config) throws ServletException {
        Object o = this.configuredFilters.get(name);
        if (o == null) {
            String msg = "There is no configured filter for filter name '" + name + "'";
            throw new IllegalArgumentException(msg);
        }
        if (o instanceof Filter) {
            return (Filter)o;
        }
        FilterBuilder builder = Filters.builder().setServletContext(this.servletContext).setName(name);
        boolean hasPathConfig = Strings.hasText((String)config);
        if (hasPathConfig) {
            builder.setPathConfig(config);
        }
        if (o instanceof Class) {
            Class c = (Class)o;
            if (Filter.class.isAssignableFrom(c)) {
                builder.setFilterClass(c);
            } else if (Factory.class.isAssignableFrom(c)) {
                o = Classes.newInstance((Class)c);
            }
        }
        if (o instanceof Factory) {
            Factory factory = (Factory)o;
            if (factory instanceof ServletContextInitializable) {
                ((ServletContextInitializable)((Object)factory)).init(this.servletContext);
            }
            Filter filter = (Filter)factory.getInstance();
            builder.setFilter(filter);
        }
        return builder.build();
    }

    @Override
    public void createChain(String chainName, String chainDefinition) throws ServletException {
        String[] filterTokens;
        if (!Strings.hasText((String)chainName)) {
            throw new NullPointerException("chainName cannot be null or empty.");
        }
        if (!Strings.hasText((String)chainDefinition)) {
            throw new NullPointerException("chainDefinition cannot be null or empty.");
        }
        log.debug("Creating chain [{}] from String definition [{}]", (Object)chainName, (Object)chainDefinition);
        for (String token : filterTokens = this.splitChainDefinition(chainDefinition)) {
            String[] nameConfigPair = this.toNameConfigPair(token);
            this.addToChain(chainName, nameConfigPair[0], nameConfigPair[1]);
        }
    }

    protected String[] splitChainDefinition(String chainDefinition) {
        return Strings.split((String)chainDefinition, (char)',', (char)'(', (char)')', (boolean)true, (boolean)true);
    }

    protected String[] toNameConfigPair(String token) throws IllegalArgumentException {
        try {
            String[] pair = token.split("\\(", 2);
            String name = Strings.clean((String)pair[0]);
            if (name == null) {
                throw new IllegalArgumentException("Filter name not found for filter chain definition token: " + token);
            }
            String config = null;
            if (pair.length == 2) {
                config = Strings.clean((String)pair[1]);
                config = config.substring(0, config.length() - 1);
                config = Strings.clean((String)config);
            }
            return new String[]{name, config};
        }
        catch (Exception e) {
            String msg = "Unable to parse filter chain definition token: " + token;
            throw new IllegalArgumentException(msg, e);
        }
    }

    public void addToChain(String chainName, String filterName, String config) throws ServletException {
        if (!Strings.hasText((String)chainName)) {
            throw new IllegalArgumentException("chainName cannot be null or empty.");
        }
        Filter filter = this.createFilter(filterName, config);
        List<Filter> chain = this.ensureChain(chainName);
        chain.add(filter);
    }

    protected List<Filter> ensureChain(String chainName) {
        List<Filter> chain = this.getChain(chainName);
        if (chain == null) {
            chain = new ArrayList<Filter>();
            this.filterChains.put(chainName, chain);
        }
        return chain;
    }

    @Override
    public List<Filter> getChain(String chainName) {
        return this.filterChains.get(chainName);
    }

    @Override
    public boolean hasChains() {
        return !Collections.isEmpty(this.filterChains);
    }

    @Override
    public Set<String> getChainNames() {
        return this.filterChains.keySet();
    }

    @Override
    public FilterChain proxy(FilterChain original, String chainName) {
        List<Filter> configured = this.getChain(chainName);
        if (configured == null) {
            String msg = "There is no configured chain under the name/key [" + chainName + "].";
            throw new IllegalArgumentException(msg);
        }
        return new ProxiedFilterChain(original, configured);
    }
}

