/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

public class DefaultFilterConfig
implements FilterConfig {
    private final ServletContext servletContext;
    private final String name;
    private final Map<String, String> initParams;

    public DefaultFilterConfig(ServletContext servletContext, String name, Map<String, String> initParams) {
        Assert.notNull((Object)servletContext, (String)"servletContext is required.");
        Assert.hasText((String)name, (String)"name is required and cannot be null or empty.");
        this.servletContext = servletContext;
        this.name = name;
        this.initParams = initParams != null ? Collections.unmodifiableMap(initParams) : Collections.emptyMap();
    }

    public String getFilterName() {
        return this.name;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        Set<String> names = this.initParams.keySet();
        return Collections.enumeration(names);
    }
}

