/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.UsernamePasswordRequestBuilder;
import com.stormpath.sdk.authc.UsernamePasswordRequests;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.UsernamePasswordRequestFactory;
import com.stormpath.sdk.servlet.http.authc.AccountStoreResolver;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultUsernamePasswordRequestFactory
implements UsernamePasswordRequestFactory {
    private AccountStoreResolver accountStoreResolver;

    public DefaultUsernamePasswordRequestFactory(AccountStoreResolver accountStoreResolver) {
        Assert.notNull((Object)accountStoreResolver, (String)"AccountStoreResolver cannot be null.");
        this.accountStoreResolver = accountStoreResolver;
    }

    protected AccountStoreResolver getAccountStoreResolver() {
        return this.accountStoreResolver;
    }

    @Override
    public AuthenticationRequest createUsernamePasswordRequest(HttpServletRequest request, HttpServletResponse response, String username, String password) {
        AccountStore accountStore = this.getAccountStoreResolver().getAccountStore(request, response);
        UsernamePasswordRequestBuilder builder = UsernamePasswordRequests.builder().setUsernameOrEmail(username).setPassword(password).setHost(request.getRemoteHost());
        if (accountStore != null) {
            builder.inAccountStore(accountStore);
        }
        return builder.build();
    }
}

