/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.impl.http.HttpHeadersHolder;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.FilterChainResolver;
import com.stormpath.sdk.servlet.filter.HttpFilter;
import com.stormpath.sdk.servlet.filter.WrappedServletRequestFactory;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StormpathFilter
extends HttpFilter {
    private FilterChainResolver filterChainResolver;
    private Set<String> clientRequestAttributeNames = Collections.emptySet();
    private Set<String> applicationRequestAttributeNames = Collections.emptySet();
    private WrappedServletRequestFactory factory;
    private Client client;
    private Application application;

    public void setFilterChainResolver(FilterChainResolver filterChainResolver) {
        Assert.notNull((Object)filterChainResolver, (String)"FilterChainResolver cannot be null.");
        this.filterChainResolver = filterChainResolver;
    }

    public void setClientRequestAttributeNames(Set<String> clientRequestAttributeNames) {
        this.clientRequestAttributeNames = clientRequestAttributeNames != null ? clientRequestAttributeNames : new LinkedHashSet();
    }

    public void setApplicationRequestAttributeNames(Set<String> applicationRequestAttributeNames) {
        this.applicationRequestAttributeNames = applicationRequestAttributeNames != null ? applicationRequestAttributeNames : new LinkedHashSet();
    }

    public void setWrappedServletRequestFactory(WrappedServletRequestFactory factory) {
        Assert.notNull((Object)factory, (String)"WrappedServletRequestFactory cannot be null.");
        this.factory = factory;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    @Override
    protected void onInit() throws ServletException {
        Assert.notNull((Object)this.filterChainResolver, (String)"FilterChainResolver cannot be null.");
        Assert.notNull(this.clientRequestAttributeNames, (String)"clientRequestAttributeNames cannot be null.");
        Assert.notNull(this.applicationRequestAttributeNames, (String)"applicationRequestAttributeNames cannot be null.");
        Assert.notNull((Object)this.factory, (String)"WrappedServletRequestFactory cannot be null.");
        Assert.notNull((Object)this.client, (String)"Client instance cannot be null.");
        Assert.notNull((Object)this.application, (String)"Application instance cannot be null.");
    }

    protected FilterChainResolver getFilterChainResolver() {
        return this.filterChainResolver;
    }

    @Override
    public void filter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        FilterChainResolver resolver = this.getFilterChainResolver();
        Assert.notNull((Object)resolver, (String)"Filter has not yet been configured. Explicitly call setFilterChainResolver or init(FilterConfig).");
        this.setRequestAttributes(request);
        request = this.wrapRequest(request, response);
        FilterChain target = resolver.getChain(request, response, chain);
        target.doFilter((ServletRequest)request, (ServletResponse)response);
        HttpHeadersHolder.clear();
    }

    protected void setRequestAttributes(HttpServletRequest request) {
        this.setClientRequestAttributes(request);
        this.setApplicationRequestAttributes(request);
        LinkedHashMap headersMap = new LinkedHashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headersMap.put(name.toLowerCase(), Collections.list(request.getHeaders(name)));
        }
        HttpHeadersHolder.set(headersMap);
    }

    protected void setClientRequestAttributes(HttpServletRequest request) {
        String name = Client.class.getName();
        request.setAttribute(name, (Object)this.client);
        for (String aName : this.clientRequestAttributeNames) {
            request.setAttribute(aName, (Object)this.client);
        }
    }

    protected void setApplicationRequestAttributes(HttpServletRequest request) {
        String name = Application.class.getName();
        request.setAttribute(name, (Object)this.application);
        for (String aName : this.applicationRequestAttributeNames) {
            request.setAttribute(aName, (Object)this.application);
        }
    }

    protected HttpServletRequest wrapRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.factory.wrapHttpServletRequest(request, response);
    }
}

