/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.filter.AccessControlFilter;
import com.stormpath.sdk.servlet.filter.account.HttpImmutableAccount;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class AccountAuthorizationFilter
extends AccessControlFilter {
    public static final String PATH_CONFIG_INIT_PARAM_NAME = "pathConfig";
    private Expression expression;

    protected String getPathConfig() {
        return this.getFilterConfig().getInitParameter(PATH_CONFIG_INIT_PARAM_NAME);
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        String pathConfig = Strings.clean((String)this.getPathConfig());
        if (pathConfig != null) {
            try {
                this.expression = this.createExpression(pathConfig);
            }
            catch (Exception e) {
                String msg = "Unable to compile authorization expression [" + pathConfig + "]: " + e.getMessage();
                throw new ServletException(msg, (Throwable)e);
            }
        }
        super.onInit();
    }

    protected Expression createExpression(String pathConfig) {
        SpelCompilerMode mode = SpelCompilerMode.MIXED;
        ClassLoader cl = this.getClass().getClassLoader();
        SpelParserConfiguration config = new SpelParserConfiguration(mode, cl);
        SpelExpressionParser parser = new SpelExpressionParser(config);
        return parser.parseExpression(pathConfig);
    }

    @Override
    protected boolean isAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (AccountResolver.INSTANCE.hasAccount((ServletRequest)request)) {
            if (this.expression != null) {
                Account requestAccount = AccountResolver.INSTANCE.getRequiredAccount((ServletRequest)request);
                HttpImmutableAccount account = new HttpImmutableAccount(requestAccount, request, response);
                StandardEvaluationContext ctx = new StandardEvaluationContext((Object)account);
                Object value = this.expression.getValue((EvaluationContext)ctx);
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                String msg = "Specified authorization expression [" + this.getPathConfig() + "] must result in a " + "boolean return value.";
                throw new ServletException(msg);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onAccessDenied(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!AccountResolver.INSTANCE.hasAccount((ServletRequest)request)) {
            return this.getUnauthenticatedHandler().onAuthenticationRequired(request, response);
        }
        return this.getUnauthorizedHandler().onUnauthorized(request, response);
    }
}

