/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.account.DefaultAccountResolver;
import com.stormpath.sdk.servlet.http.Saver;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationResultSaver
implements Saver<AuthenticationResult> {
    private List<Saver<AuthenticationResult>> savers;

    public AuthenticationResultSaver(List<Saver<AuthenticationResult>> savers) {
        Assert.notEmpty(savers, (String)"At least one Saver<AuthenticationResult> must be specified.");
        this.savers = Collections.unmodifiableList(savers);
    }

    @Override
    public void set(HttpServletRequest request, HttpServletResponse response, AuthenticationResult result) {
        for (Saver<AuthenticationResult> saver : this.savers) {
            saver.set(request, response, result);
        }
        if (result == null) {
            request.removeAttribute(DefaultAccountResolver.REQUEST_ATTR_NAME);
            request.removeAttribute("account");
            return;
        }
        Account account = result.getAccount();
        request.setAttribute(DefaultAccountResolver.REQUEST_ATTR_NAME, (Object)account);
        request.setAttribute("account", (Object)account);
    }
}

