/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.oauth.AccessTokenResult;
import com.stormpath.sdk.oauth.Authenticators;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthenticationBuilder;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.config.CookieConfig;
import com.stormpath.sdk.servlet.filter.account.JwtAccountResolver;
import com.stormpath.sdk.servlet.filter.oauth.AccessTokenResultFactory;
import com.stormpath.sdk.servlet.http.CookieResolver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.http.impl.StormpathHttpServletRequest;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieAccountResolver
implements Resolver<Account> {
    private static final Logger log = LoggerFactory.getLogger(CookieAccountResolver.class);
    private final JwtAccountResolver jwtAccountResolver;
    private final CookieResolver accessTokenCookieResolver;
    private final CookieResolver refreshTokenCookieResolver;
    private final Saver<AuthenticationResult> authenticationResultSaver;
    private final AccessTokenResultFactory accessTokenResultFactory;

    public CookieAccountResolver(CookieConfig accessTokenCookieConfig, CookieConfig refreshTokenCookieConfig, JwtAccountResolver jwtAccountResolver, Saver<AuthenticationResult> authenticationResultSaver, AccessTokenResultFactory accessTokenResultFactory) {
        Assert.notNull((Object)accessTokenCookieConfig, (String)"accessTokenCookieConfig cannot be null.");
        Assert.notNull((Object)refreshTokenCookieConfig, (String)"refreshTokenCookieConfig cannot be null.");
        Assert.notNull((Object)jwtAccountResolver, (String)"jwtAccountResolver cannot be null.");
        Assert.notNull((Object)accessTokenResultFactory, (String)"accessTokenResultFactory cannot be null.");
        Assert.notNull(authenticationResultSaver, (String)"authenticationResultSaver cannot be null.");
        this.jwtAccountResolver = jwtAccountResolver;
        this.accessTokenCookieResolver = new CookieResolver(accessTokenCookieConfig.getName());
        this.refreshTokenCookieResolver = new CookieResolver(refreshTokenCookieConfig.getName());
        this.accessTokenResultFactory = accessTokenResultFactory;
        this.authenticationResultSaver = authenticationResultSaver;
    }

    @Override
    public Account get(HttpServletRequest request, HttpServletResponse response) {
        String val;
        Cookie cookie = this.accessTokenCookieResolver.get(request, response);
        if (cookie != null && Strings.hasText((String)(val = cookie.getValue()))) {
            try {
                return this.getAccount(request, response, val);
            }
            catch (Exception e) {
                String msg = "Encountered invalid JWT in access_token cookie. It might have expired, let's try with the refresh token now.";
                log.debug(msg, (Throwable)e);
            }
        }
        return this.tryRefreshToken(request, response);
    }

    protected Account getAccount(HttpServletRequest request, HttpServletResponse response, String jwt) {
        Account account = this.jwtAccountResolver.getAccountByJwt(request, response, jwt);
        if (account != null) {
            request.setAttribute(StormpathHttpServletRequest.AUTH_TYPE_REQUEST_ATTRIBUTE_NAME, (Object)"FORM");
        }
        return account;
    }

    protected void deleteCookie(HttpServletResponse response, Cookie cookie) {
        if (!response.isCommitted() && cookie != null) {
            cookie.setValue("");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    protected Account tryRefreshToken(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = this.refreshTokenCookieResolver.get(request, response);
        if (cookie == null) {
            return null;
        }
        String val = cookie.getValue();
        if (!Strings.hasText((String)val)) {
            return null;
        }
        try {
            OAuthRefreshTokenRequestAuthentication refreshGrantRequest = ((OAuthRefreshTokenRequestAuthenticationBuilder)OAuthRequests.OAUTH_REFRESH_TOKEN_REQUEST.builder()).setRefreshToken(val).build();
            OAuthGrantRequestAuthenticationResult authenticationResult = (OAuthGrantRequestAuthenticationResult)((OAuthRefreshTokenRequestAuthenticator)Authenticators.OAUTH_REFRESH_TOKEN_REQUEST_AUTHENTICATOR.forApplication(ApplicationResolver.INSTANCE.getApplication((ServletRequest)request))).authenticate((OAuthRequestAuthentication)refreshGrantRequest);
            AccessTokenResult accessTokenResult = this.accessTokenResultFactory.createAccessTokenResult(request, response, authenticationResult);
            this.authenticationResultSaver.set(request, response, (AuthenticationResult)accessTokenResult);
            return this.getAccount(request, response, authenticationResult.getAccessToken().getJwt());
        }
        catch (Exception e) {
            String msg = "Encountered invalid JWT in refresh_token cookie. We will now delete both the access and refresh cookies for safety.";
            log.error(msg, (Throwable)e);
            this.deleteCookie(response, cookie);
            this.deleteCookie(response, this.accessTokenCookieResolver.get(request, response));
            return null;
        }
    }
}

