/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.account.JwtAccountResolver;
import com.stormpath.sdk.servlet.filter.account.JwtSigningKeyResolver;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import java.security.Key;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultJwtAccountResolver
implements JwtAccountResolver {
    private final JwtSigningKeyResolver jwtSigningKeyResolver;

    public DefaultJwtAccountResolver(JwtSigningKeyResolver jwtSigningKeyResolver) {
        Assert.notNull((Object)jwtSigningKeyResolver, (String)"JwtSigningKeyResolver cannot be null.");
        this.jwtSigningKeyResolver = jwtSigningKeyResolver;
    }

    protected JwtSigningKeyResolver getJwtSigningKeyResolver() {
        return this.jwtSigningKeyResolver;
    }

    @Override
    public Account getAccountByJwt(final HttpServletRequest request, final HttpServletResponse response, String jwt) {
        final JwtSigningKeyResolver resolver = this.getJwtSigningKeyResolver();
        SigningKeyResolverAdapter signingKeyResolver = new SigningKeyResolverAdapter(){

            public Key resolveSigningKey(JwsHeader header, Claims claims) {
                return resolver.getSigningKey(request, response, header, claims);
            }
        };
        Jws jws = Jwts.parser().setSigningKeyResolver((SigningKeyResolver)signingKeyResolver).parseClaimsJws(jwt);
        Claims claims = (Claims)jws.getBody();
        if ("refresh".equals(((JwsHeader)jws.getHeader()).get((Object)"stt"))) {
            return null;
        }
        String accountHref = claims.getSubject();
        Client client = this.getClient(request);
        return (Account)client.getResource(accountHref, Account.class);
    }

    protected Client getClient(HttpServletRequest request) {
        return (Client)request.getAttribute(Client.class.getName());
    }
}

