/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.http.Saver;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionAuthenticationResultSaver
implements Saver<AuthenticationResult> {
    private final Set<String> sessionAttributeNames;

    public SessionAuthenticationResultSaver(Set<String> sessionAttributeNames) {
        Assert.notEmpty(sessionAttributeNames, (String)"Session attribute names Set cannot be null or empty.");
        this.sessionAttributeNames = sessionAttributeNames;
    }

    @Override
    public void set(HttpServletRequest request, HttpServletResponse response, AuthenticationResult result) {
        if (result == null) {
            this.remove(request);
            return;
        }
        Account account = result.getAccount();
        HttpSession session = request.getSession();
        for (String name : this.sessionAttributeNames) {
            session.setAttribute(name, (Object)account);
        }
    }

    protected void remove(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            for (String name : this.sessionAttributeNames) {
                session.removeAttribute(name);
            }
        }
    }
}

