/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account.config;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigResolver;
import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.config.CookieConfig;
import com.stormpath.sdk.servlet.filter.account.CookieAccountResolver;
import com.stormpath.sdk.servlet.filter.account.JwtAccountResolver;
import com.stormpath.sdk.servlet.filter.oauth.DefaultAccessTokenResultFactory;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.Saver;
import javax.servlet.ServletContext;

public class CookieAccountResolverFactory
extends ConfigSingletonFactory<Resolver<Account>> {
    protected static final String JWT_ACCOUNT_RESOLVER = "stormpath.web.account.jwt.resolver";
    protected static final String COOKIE_SAVER = "stormpath.web.authc.savers.cookie";

    @Override
    protected Resolver<Account> createInstance(ServletContext servletContext) throws Exception {
        Config config = ConfigResolver.INSTANCE.getConfig(servletContext);
        CookieConfig accessTokenCookieConfig = config.getAccessTokenCookieConfig();
        CookieConfig refreshTokenCookieConfig = config.getRefreshTokenCookieConfig();
        JwtAccountResolver resolver = (JwtAccountResolver)config.getInstance(JWT_ACCOUNT_RESOLVER);
        Saver cookieAuthenticationResultSaverFactory = (Saver)config.getInstance(COOKIE_SAVER);
        DefaultAccessTokenResultFactory accessTokenResultFactory = new DefaultAccessTokenResultFactory(ApplicationResolver.INSTANCE.getApplication(servletContext));
        return new CookieAccountResolver(accessTokenCookieConfig, refreshTokenCookieConfig, resolver, cookieAuthenticationResultSaverFactory, accessTokenResultFactory);
    }
}

