/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account.config;

import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigResolver;
import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.config.CookieConfig;
import com.stormpath.sdk.servlet.filter.account.CookieAuthenticationResultSaver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.Saver;
import javax.servlet.ServletContext;

public class CookieAuthenticationResultSaverFactory
extends ConfigSingletonFactory<Saver<AuthenticationResult>> {
    protected static final String COOKIE_SECURE_RESOLVER = "stormpath.web.cookie.secure.resolver";

    @Override
    protected Saver<AuthenticationResult> createInstance(ServletContext servletContext) throws Exception {
        Config config = ConfigResolver.INSTANCE.getConfig(servletContext);
        CookieConfig accessTokenCookieConfig = config.getAccessTokenCookieConfig();
        CookieConfig refreshTokenCookieConfig = config.getRefreshTokenCookieConfig();
        Resolver secureCookieRequired = (Resolver)config.getInstance(COOKIE_SECURE_RESOLVER);
        return new CookieAuthenticationResultSaver(accessTokenCookieConfig, refreshTokenCookieConfig, secureCookieRequired);
    }
}

