/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.oauth;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthenticationBuilder;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import com.stormpath.sdk.servlet.filter.oauth.OAuthException;
import com.stormpath.sdk.servlet.filter.oauth.RefreshTokenAuthenticationRequestFactory;
import javax.servlet.http.HttpServletRequest;

public class DefaultRefreshTokenAuthenticationRequestFactory
implements RefreshTokenAuthenticationRequestFactory {
    protected static final String REFRESH_TOKEN_GRANT_TYPE = "refresh_token";

    @Override
    public OAuthRefreshTokenRequestAuthentication createRefreshTokenAuthenticationRequest(HttpServletRequest request) throws OAuthException {
        try {
            String refreshToken = Strings.clean((String)request.getParameter(REFRESH_TOKEN_GRANT_TYPE));
            Assert.hasText((String)refreshToken, (String)"refreshToken must not be null or empty.");
            return ((OAuthRefreshTokenRequestAuthenticationBuilder)OAuthRequests.OAUTH_REFRESH_TOKEN_REQUEST.builder()).setRefreshToken(refreshToken).build();
        }
        catch (Exception e) {
            throw new OAuthException(OAuthErrorCode.INVALID_REQUEST);
        }
    }
}

