/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.oauth;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.impl.oauth.authz.DefaultTokenResponse;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.AccessTokenResult;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.TokenResponse;
import com.stormpath.sdk.servlet.filter.oauth.PasswordGrantAccessTokenResult;
import com.stormpath.sdk.servlet.filter.oauth.RefreshTokenResultFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.common.message.types.TokenType;

public class DefaultRefreshTokenResultFactory
implements RefreshTokenResultFactory {
    private final Application application;

    public DefaultRefreshTokenResultFactory(Application application) {
        Assert.notNull((Object)application, (String)"application argument cannot be null.");
        this.application = application;
    }

    @Override
    public AccessTokenResult createRefreshTokenResult(HttpServletRequest request, HttpServletResponse response, OAuthGrantRequestAuthenticationResult result) {
        TokenResponse tokenResponse = DefaultTokenResponse.tokenType((TokenType)TokenType.BEARER).accessToken(result.getAccessTokenString()).refreshToken(result.getRefreshTokenString()).applicationHref(this.application.getHref()).expiresIn(String.valueOf(result.getExpiresIn())).build();
        return new PasswordGrantAccessTokenResult(result.getAccessToken().getAccount(), tokenResponse);
    }
}

