/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.oauth;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;

public class OAuthException
extends RuntimeException {
    private final OAuthErrorCode errorCode;
    private final String message;

    public OAuthException(OAuthErrorCode code) {
        this(code, null, null);
    }

    public OAuthException(OAuthErrorCode code, String message) {
        super(message != null ? message : (code != null ? code.getValue() : ""));
        Assert.notNull((Object)code, (String)"OAuthErrorCode cannot be null.");
        this.errorCode = code;
        this.message = message;
    }

    public OAuthException(OAuthErrorCode code, String message, Exception cause) {
        super(message != null ? message : (code != null ? code.getValue() : ""), cause);
        Assert.notNull((Object)code, (String)"OAuthErrorCode cannot be null.");
        this.errorCode = code;
        this.message = message;
    }

    public OAuthErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String toJson() {
        String json = "{" + OAuthException.toJson("error", this.getErrorCode());
        String val = this.getMessage();
        if (Strings.hasText((String)val)) {
            json = json + "," + OAuthException.toJson("message", val);
        }
        json = json + "}";
        return json;
    }

    protected static String toJson(String name, Object value) {
        String stringValue = String.valueOf(value);
        return OAuthException.quote(name) + ":" + OAuthException.quote(stringValue);
    }

    protected static String quote(String val) {
        return "\"" + val + "\"";
    }
}

