/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.oauth;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.authz.RequestAuthorizer;
import com.stormpath.sdk.servlet.filter.ServerUriResolver;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import com.stormpath.sdk.servlet.filter.oauth.OAuthException;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.Resolver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginAccessTokenRequestAuthorizer
implements RequestAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(OriginAccessTokenRequestAuthorizer.class);
    public static final String ACCEPTS_HEADER_NAME = "Accept";
    public static final String ORIGIN_HEADER_NAME = "Origin";
    public static final String REFERER_HEADER_NAME = "Referer";
    public static final String ORIGIN_URIS_CONFIG_PROPERTY_NAME = "stormpath.web.oauth2.origin.authorizer.originUris";
    private final ServerUriResolver serverUriResolver;
    private final Resolver<Boolean> localhost;
    private final Collection<String> authorizedOriginUrls;
    private final boolean producesFavorsJSON;

    public OriginAccessTokenRequestAuthorizer(ServerUriResolver serverUriResolver, Resolver<Boolean> localhost, Collection<String> authorizedOriginUrls, List<MediaType> producesMimeTypes) {
        Assert.notNull((Object)serverUriResolver, (String)"ServerUriResolver cannot be null.");
        Assert.notNull(localhost, (String)"localhost resolver cannot be null.");
        this.serverUriResolver = serverUriResolver;
        this.localhost = localhost;
        this.authorizedOriginUrls = authorizedOriginUrls == null ? Collections.emptyList() : authorizedOriginUrls;
        this.producesFavorsJSON = producesMimeTypes == null ? false : producesMimeTypes.size() > 0 && producesMimeTypes.get(0).includes(MediaType.APPLICATION_JSON);
    }

    public ServerUriResolver getServerUriResolver() {
        return this.serverUriResolver;
    }

    public Resolver<Boolean> getLocalhostResolver() {
        return this.localhost;
    }

    public Collection<String> getAuthorizedOriginUrls() {
        return this.authorizedOriginUrls;
    }

    @Override
    public void assertAuthorized(HttpServletRequest request, HttpServletResponse response) throws OAuthException {
        boolean originHeaderNotRequired;
        String accepts = Strings.clean((String)request.getHeader(ACCEPTS_HEADER_NAME));
        boolean bl = originHeaderNotRequired = accepts.contains("application/json") || this.producesFavorsJSON;
        if (!originHeaderNotRequired) {
            boolean localhostClient = this.isLocalhostClient(request, response);
            String origin = Strings.clean((String)request.getHeader(ORIGIN_HEADER_NAME));
            boolean fallbackToReferer = false;
            if (origin == null && (origin = Strings.clean((String)request.getHeader(REFERER_HEADER_NAME))) != null) {
                fallbackToReferer = true;
            }
            if (!Strings.hasText((String)origin)) {
                String errorMessage = null;
                if (localhostClient) {
                    errorMessage = "Missing Origin or Referer header (Origin preferred).";
                }
                log.debug("Request client (remoteAddr={}) did not specify an Origin or Referer header. Access Token request is denied", (Object)request.getRemoteAddr());
                throw new OAuthException(OAuthErrorCode.INVALID_CLIENT, errorMessage, null);
            }
            if (!this.isAuthorizedOrigin(request, response, origin)) {
                String errorMessage = null;
                if (localhostClient) {
                    errorMessage = "Unauthorized request " + (fallbackToReferer ? "origin (via Referer header)." : "Origin.");
                }
                log.debug("Unauthorized {} header value: {}.  If this is unexpected, you might want to specify one or more comma-delimited URLs via the {} property.", new Object[]{fallbackToReferer ? REFERER_HEADER_NAME : ORIGIN_HEADER_NAME, origin, ORIGIN_URIS_CONFIG_PROPERTY_NAME});
                throw new OAuthException(OAuthErrorCode.INVALID_CLIENT, errorMessage, null);
            }
        }
    }

    protected boolean isAuthorizedOrigin(HttpServletRequest request, HttpServletResponse response, String origin) {
        String requestedServerUri = this.getServerUriResolver().getServerUri(request);
        if (origin.startsWith(requestedServerUri)) {
            return true;
        }
        for (String authorizedOriginUri : this.getAuthorizedOriginUrls()) {
            if (!origin.startsWith(authorizedOriginUri)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLocalhostClient(HttpServletRequest request, HttpServletResponse response) {
        return this.getLocalhostResolver().get(request, response);
    }
}

