/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.form;

import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.form.Field;
import com.stormpath.sdk.servlet.form.Form;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultForm
implements Form {
    private final Map<String, Field> fields = new LinkedHashMap<String, Field>();

    public static Builder builder() {
        return new Builder();
    }

    public DefaultForm(Builder builder) {
        for (Field field : builder.fields) {
            this.fields.put(field.getName(), field);
        }
    }

    @Override
    public List<Field> getFields() {
        return new ArrayList<Field>(this.fields.values());
    }

    @Override
    public Field getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public String getFieldValue(String fieldName) {
        Field field = this.fields.get(fieldName);
        if (field != null) {
            return Strings.clean((String)field.getValue());
        }
        return null;
    }

    @Override
    public void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public static class Builder {
        List<Field> fields;

        public Builder setFields(List<Field> fields) {
            this.fields = fields;
            return this;
        }

        public DefaultForm build() {
            return new DefaultForm(this);
        }
    }
}

