/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.http.Resolver;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieResolver
implements Resolver<Cookie> {
    private final String name;

    public CookieResolver(String name) {
        Assert.hasText((String)name, (String)"cookie name argument cannot be null or empty.");
        this.name = name;
    }

    @Override
    public Cookie get(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!this.name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }
}

