/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.authc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.authc.AuthenticationResultVisitor;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.Authenticators;
import com.stormpath.sdk.oauth.OAuthAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthenticationBuilder;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.filter.account.JwtSigningKeyResolver;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import com.stormpath.sdk.servlet.filter.oauth.OAuthException;
import com.stormpath.sdk.servlet.http.authc.AbstractAuthenticationScheme;
import com.stormpath.sdk.servlet.http.authc.DefaultHttpAuthenticationResult;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationAttempt;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationException;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationResult;
import com.stormpath.sdk.servlet.http.authc.HttpCredentials;
import com.stormpath.sdk.servlet.http.impl.StormpathHttpServletRequest;
import com.stormpath.sdk.servlet.oauth.AccessTokenValidationStrategy;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerAuthenticationScheme
extends AbstractAuthenticationScheme {
    private static final Logger log = LoggerFactory.getLogger(BearerAuthenticationScheme.class);
    private static final String NAME = "Bearer";
    private JwtSigningKeyResolver jwtSigningKeyResolver;
    private boolean withLocalValidation;

    public BearerAuthenticationScheme(JwtSigningKeyResolver jwtSigningKeyResolver, AccessTokenValidationStrategy validation) {
        Assert.notNull((Object)jwtSigningKeyResolver, (String)"JwtSigningKeyResolver cannot be null.");
        this.jwtSigningKeyResolver = jwtSigningKeyResolver;
        this.withLocalValidation = validation.equals((Object)AccessTokenValidationStrategy.LOCAL);
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected JwtSigningKeyResolver getJwtSigningKeyResolver() {
        return this.jwtSigningKeyResolver;
    }

    @Override
    public HttpAuthenticationResult authenticate(HttpAuthenticationAttempt attempt) throws HttpAuthenticationException {
        Assert.notNull((Object)attempt, (String)"attempt cannot be null.");
        HttpServletRequest request = attempt.getRequest();
        Assert.notNull((Object)request, (String)"attempt request property cannot be null.");
        HttpServletResponse response = attempt.getResponse();
        Assert.notNull((Object)response, (String)"attempt response property cannot be null.");
        HttpCredentials credentials = attempt.getCredentials();
        Assert.notNull((Object)credentials, (String)"credentials cannot be null.");
        Assert.isTrue((boolean)NAME.equalsIgnoreCase(credentials.getSchemeName()), (String)"Unsupported scheme.");
        String token = attempt.getCredentials().getSchemeValue();
        Assert.hasText((String)token, (String)"Cannot authenticate empty Bearer value.");
        try {
            HttpAuthenticationResult result = this.authenticate(request, response, token);
            request.setAttribute(StormpathHttpServletRequest.AUTH_TYPE_REQUEST_ATTRIBUTE_NAME, (Object)NAME);
            return result;
        }
        catch (OAuthException e) {
            response.setStatus(401);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store, no-cache");
            response.setHeader("Pragma", "no-cache");
            try {
                response.getWriter().print(e.toJson());
                response.getWriter().flush();
            }
            catch (IOException e2) {
                throw new HttpAuthenticationException("Unable to render OAuth error response body: " + e2.getMessage(), e2);
            }
            throw new HttpAuthenticationException("OAuth request authentication failed: " + e.getMessage(), e);
        }
    }

    protected HttpAuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, String token) {
        try {
            OAuthBearerRequestAuthentication jwtrequest = (OAuthBearerRequestAuthentication)((OAuthBearerRequestAuthenticationBuilder)OAuthRequests.OAUTH_BEARER_REQUEST.builder()).setJwt(token).build();
            OAuthBearerRequestAuthenticator OAuthBearerRequestAuthenticator2 = (OAuthBearerRequestAuthenticator)Authenticators.OAUTH_BEARER_REQUEST_AUTHENTICATOR.forApplication(this.getApplication(request));
            if (this.withLocalValidation) {
                OAuthBearerRequestAuthenticator2.withLocalValidation();
            }
            OAuthBearerRequestAuthenticationResult jwtResult = (OAuthBearerRequestAuthenticationResult)OAuthBearerRequestAuthenticator2.authenticate((OAuthRequestAuthentication)jwtrequest);
            return this.createAuthenticationResult(request, response, jwtResult.getAccount());
        }
        catch (ExpiredJwtException e) {
            throw new OAuthException(OAuthErrorCode.INVALID_CLIENT, "access_token is expired.", (Exception)((Object)e));
        }
        catch (OAuthException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug("JWT verification failed.", (Throwable)e);
            throw new OAuthException(OAuthErrorCode.INVALID_CLIENT, "access_token is invalid.", e);
        }
    }

    protected HttpAuthenticationResult createAuthenticationResult(HttpServletRequest request, HttpServletResponse response, Account account) throws OAuthException {
        Object authcResult;
        String accountHref = account.getHref();
        if (account.getHref().contains("apiKeys")) {
            int i = accountHref.lastIndexOf(47);
            String id = accountHref.substring(i + 1);
            final ApiKey apiKey = this.getTokenApiKey(request, id);
            authcResult = new OAuthAuthenticationResult(){

                public Set<String> getScope() {
                    return Collections.emptySet();
                }

                public ApiKey getApiKey() {
                    return apiKey;
                }

                public Account getAccount() {
                    return apiKey.getAccount();
                }

                public void accept(AuthenticationResultVisitor visitor) {
                    visitor.visit((OAuthAuthenticationResult)this);
                }

                public String getHref() {
                    return null;
                }
            };
        } else {
            if (account.getStatus() != AccountStatus.ENABLED) {
                throw new OAuthException(OAuthErrorCode.INVALID_CLIENT, "account is disabled.", null);
            }
            authcResult = new TransientAuthenticationResult(account);
        }
        return new DefaultHttpAuthenticationResult(request, response, (AuthenticationResult)authcResult);
    }

    protected Client getClient(HttpServletRequest request) {
        return (Client)request.getAttribute(Client.class.getName());
    }

    protected ApiKey getTokenApiKey(HttpServletRequest request, String apiKeyId) throws OAuthException {
        try {
            return this.getEnabledApiKey(request, apiKeyId);
        }
        catch (ResourceException e) {
            OAuthErrorCode err = OAuthErrorCode.INVALID_CLIENT;
            String msg = e.getStormpathError().getDeveloperMessage();
            throw new OAuthException(err, msg, (Exception)((Object)e));
        }
    }
}

