/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.impl;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.UserAgent;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DefaultUserAgent
implements UserAgent {
    private static final String ACCEPT_HEADER_NAME = "Accept";
    private final HttpServletRequest request;
    private List<MediaType> acceptedMediaTypes;
    private Boolean jsonPreferred;
    private Boolean htmlPreferred;

    public DefaultUserAgent(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request argument cannot be null.");
        this.request = request;
    }

    @Override
    public boolean isBrowser() {
        String ua = this.request.getHeader("User-Agent");
        if (ua == null) {
            return false;
        }
        return ua.startsWith("Mozilla/") || ua.startsWith("Opera/") || ua.startsWith("Lynx/") || ua.startsWith("Links ") || ua.startsWith("Elinks ") || ua.startsWith("ELinks ") || ua.startsWith("ELinks/") || ua.startsWith("Midori/") || ua.startsWith("w3m/") || ua.startsWith("Webkit/") || ua.startsWith("Vimprobable/") || ua.startsWith("Dooble/") || ua.startsWith("Dillo/") || ua.startsWith("Surf/") || ua.startsWith("NetSurf/") || ua.startsWith("Galaxy/") || ua.startsWith("Cyberdog/") || ua.startsWith("iCab/") || ua.startsWith("IBrowse/") || ua.startsWith("IBM WebExplorer /") || ua.startsWith("AmigaVoyager/") || ua.startsWith("HotJava/") || ua.startsWith("retawq/") || ua.startsWith("uzbl ") || ua.startsWith("Uzbl ") || ua.startsWith("NCSA Mosaic/") || ua.startsWith("NCSA_Mosaic/") || ua.startsWith("WorldWideweb (NEXT)");
    }

    @Override
    public List<MediaType> getAcceptedMediaTypes() {
        List<MediaType> accepted = this.acceptedMediaTypes;
        if (accepted == null) {
            accepted = Collections.emptyList();
            String val = this.request.getHeader(ACCEPT_HEADER_NAME);
            if ((val = Strings.clean((String)val)) != null) {
                accepted = MediaType.parseMediaTypes(val);
                MediaType.sortBySpecificityAndQuality(accepted);
            }
            this.acceptedMediaTypes = accepted;
        }
        return accepted;
    }

    @Override
    public boolean isHtmlPreferred() {
        if (this.htmlPreferred == null) {
            this.htmlPreferred = this.checkHtmlPreferred();
        }
        return this.htmlPreferred;
    }

    private boolean checkHtmlPreferred() {
        List<MediaType> mediaTypes = this.getAcceptedMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            if (MediaType.APPLICATION_JSON.includes(mediaType)) {
                return false;
            }
            if (!MediaType.TEXT_HTML.includes(mediaType) && !MediaType.APPLICATION_XHTML_XML.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isJsonPreferred() {
        if (this.jsonPreferred == null) {
            this.jsonPreferred = this.checkJsonPreferred();
        }
        return this.jsonPreferred;
    }

    private boolean checkJsonPreferred() {
        List<MediaType> mediaTypes = this.getAcceptedMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            if (MediaType.APPLICATION_JSON.includes(mediaType)) {
                return true;
            }
            if (!MediaType.TEXT_HTML.includes(mediaType) && !MediaType.APPLICATION_XHTML_XML.includes(mediaType)) continue;
            return false;
        }
        return false;
    }
}

