/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.i18n;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.http.Resolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CompositeLocaleResolver
implements Resolver<Locale> {
    private List<Resolver<Locale>> resolvers;

    public CompositeLocaleResolver() {
        this.setResolvers(new ArrayList<Resolver<Locale>>());
    }

    public List<Resolver<Locale>> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(List<Resolver<Locale>> resolvers) {
        Assert.notEmpty(resolvers, (String)"Resolvers argument cannot be null or empty.");
        this.resolvers = resolvers;
    }

    @Override
    public Locale get(HttpServletRequest request, HttpServletResponse response) {
        List<Resolver<Locale>> resolvers = this.getResolvers();
        for (Resolver<Locale> localeResolver : resolvers) {
            Locale locale = localeResolver.get(request, response);
            if (locale == null) continue;
            return locale;
        }
        return request.getLocale();
    }
}

