/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.i18n;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.i18n.MessageContext;
import com.stormpath.sdk.servlet.i18n.MessageSource;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class MessageTag
extends TagSupport {
    private String key;
    private String var;
    private String scope = "page";
    private List<Object> nestedArguments;

    public void setKey(String key) {
        this.key = key;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    protected MessageContext getI18nContext() throws JspException {
        Object o = this.pageContext.getServletContext().getAttribute(MessageContext.class.getName());
        if (!(o instanceof MessageContext)) {
            String msg = "ServletContext does not contain an MessageContext instance under servlet attribute key '" + MessageContext.class.getName() + "'.  This is required for the " + ((Object)((Object)this)).getClass().getName() + " implementation to function.  This is a bug - please report it to " + "the project's issue tracker at https://github.com/stormpath/stormpath-sdk-java/issues";
            throw new JspException(msg);
        }
        return (MessageContext)o;
    }

    protected MessageSource getMessageSource() throws JspException {
        return this.getI18nContext().getMessageSource();
    }

    protected Resolver<Locale> getLocaleResolver() throws JspException {
        return this.getI18nContext().getLocaleResolver();
    }

    public int doStartTag() throws JspException {
        this.nestedArguments = new LinkedList<Object>();
        return 1;
    }

    public int getScopeCode() {
        Assert.hasText((String)this.scope, (String)"Scope cannot be null or empty.");
        if ("request".equals(this.scope)) {
            return 2;
        }
        if ("session".equals(this.scope)) {
            return 3;
        }
        if ("application".equals(this.scope)) {
            return 4;
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            String msg = this.resolveMessage();
            if (this.var != null) {
                this.pageContext.setAttribute(this.var, (Object)msg, this.getScopeCode());
            } else {
                this.writeMessage(msg);
            }
            return 6;
        }
        catch (IOException ex) {
            throw new JspTagException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void addArgument(Object argument) throws JspTagException {
        this.nestedArguments.add(argument);
    }

    private String resolveMessage() throws JspException {
        MessageSource msgSrc = this.getMessageSource();
        Resolver<Locale> localeResolver = this.getLocaleResolver();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        Locale locale = localeResolver.get(request, response);
        String key = this.key;
        if (!Strings.hasText((String)key)) {
            String msg = "Message tag 'key' attribute is required.";
            throw new JspException(msg);
        }
        if (this.nestedArguments == null) {
            return msgSrc.getMessage(key, locale);
        }
        return msgSrc.getMessage(key, locale, this.nestedArguments.toArray());
    }

    protected void writeMessage(String msg) throws IOException {
        this.pageContext.getOut().write(msg);
    }
}

