/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.io;

import com.stormpath.sdk.impl.io.ClasspathResource;
import com.stormpath.sdk.impl.io.FileResource;
import com.stormpath.sdk.impl.io.Resource;
import com.stormpath.sdk.impl.io.ResourceFactory;
import com.stormpath.sdk.impl.io.UrlResource;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.io.ServletContextResource;
import javax.servlet.ServletContext;

public class ServletContainerResourceFactory
implements ResourceFactory {
    private final ServletContext servletContext;

    public ServletContainerResourceFactory(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext cannot be null.");
        this.servletContext = servletContext;
    }

    public Resource createResource(String location) {
        Assert.hasText((String)location, (String)"location argument cannot be null or empty.");
        if (location.startsWith("classpath:")) {
            return new ClasspathResource(location);
        }
        String lcase = location.toLowerCase();
        if (location.startsWith("url:") || lcase.startsWith("http:") || lcase.startsWith("https:")) {
            return new UrlResource(location);
        }
        if (location.startsWith("file:")) {
            return new FileResource(location);
        }
        return new ServletContextResource(location, this.servletContext);
    }
}

