/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.io;

import com.stormpath.sdk.impl.io.AbstractResource;
import com.stormpath.sdk.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;

public class ServletContextResource
extends AbstractResource {
    public static final String SCHEME = "servletContext";
    private final ServletContext servletContext;

    public ServletContextResource(String location, ServletContext servletContext) {
        super(ServletContextResource.qualify(location));
        Assert.notNull((Object)servletContext, (String)"servletContext argument cannot be null.");
        this.servletContext = servletContext;
    }

    protected String canonicalize(String input) {
        return ServletContextResource.qualify(super.canonicalize(input));
    }

    private static String qualify(String location) {
        if (location != null && !location.startsWith("/")) {
            return "/" + location;
        }
        return location;
    }

    protected String getScheme() {
        return SCHEME;
    }

    public InputStream getInputStream() throws IOException {
        return this.servletContext.getResourceAsStream(this.getLocation());
    }
}

