/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Function;

public class JsonFunction<T>
implements Function<T, String> {
    private ObjectMapper objectMapper;

    public JsonFunction() {
        this(new ObjectMapper());
    }

    public JsonFunction(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper cannot be null.");
        this.objectMapper = objectMapper;
    }

    public String apply(T value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (Exception e) {
            String msg = "Cannot convert object value [" + value + "] to JSON string: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

