/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationAccountStoreMapping;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.AccountStoreVisitorAdapter;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.impl.provider.DefaultGithubProvider;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.event.RequestEvent;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.filter.ContentNegotiationResolver;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.UnresolvedMediaTypeException;
import com.stormpath.sdk.servlet.i18n.MessageSource;
import com.stormpath.sdk.servlet.mvc.Controller;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractController
implements Controller {
    private static final String GITHUB_ACCESS_TOKEN_URL = "https://github.com/login/oauth/access_token";
    private static final String GITHUB_ACCESS_TOKEN_FIELD = "access_token";
    private static final Logger log = LoggerFactory.getLogger(AbstractController.class);
    private static final HttpServlet DEFAULT_HANDLER = new HttpServlet(){};
    protected String uri;
    protected String nextUri;
    protected String view;
    protected MessageSource messageSource;
    protected Publisher<RequestEvent> eventPublisher;
    protected List<MediaType> produces;
    protected ApplicationResolver applicationResolver;
    private String controllerKey;
    private Resolver<Locale> localeResolver;
    private AccountResolver accountResolver = AccountResolver.INSTANCE;
    private ContentNegotiationResolver contentNegotiationResolver = ContentNegotiationResolver.INSTANCE;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getNextUri() {
        return this.nextUri;
    }

    public void setNextUri(String nextUri) {
        this.nextUri = nextUri;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Publisher<RequestEvent> getEventPublisher() {
        return this.eventPublisher;
    }

    public void setEventPublisher(Publisher<RequestEvent> eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public void setProduces(List<MediaType> produces) {
        this.produces = produces;
    }

    public void setControllerKey(String controllerKey) {
        this.controllerKey = controllerKey;
    }

    public String getControllerKey() {
        return this.controllerKey;
    }

    public Resolver<Locale> getLocaleResolver() {
        return this.localeResolver;
    }

    public void setLocaleResolver(Resolver<Locale> localeResolver) {
        this.localeResolver = localeResolver;
    }

    public AccountResolver getAccountResolver() {
        return this.accountResolver;
    }

    public void setAccountResolver(AccountResolver accountResolver) {
        this.accountResolver = accountResolver;
    }

    public ContentNegotiationResolver getContentNegotiationResolver() {
        return this.contentNegotiationResolver;
    }

    public void setContentNegotiationResolver(ContentNegotiationResolver contentNegotiationResolver) {
        this.contentNegotiationResolver = contentNegotiationResolver;
    }

    public void setApplicationResolver(ApplicationResolver applicationResolver) {
        this.applicationResolver = applicationResolver;
    }

    public void init() throws Exception {
        Assert.hasText((String)this.uri, (String)"uri cannot be null or empty.");
        Assert.hasText((String)this.nextUri, (String)"nextUri property cannot be null or empty.");
        Assert.hasText((String)this.view, (String)"view cannot be null or empty.");
        Assert.notNull((Object)this.messageSource, (String)"messageSource cannot be null.");
        Assert.notNull(this.eventPublisher, (String)"eventPublisher cannot be null or empty.");
        Assert.notEmpty(this.produces, (String)"produces MediaType list cannot be null or empty.");
        Assert.hasText((String)this.controllerKey, (String)"controllerKey cannot be null or empty.");
        Assert.notNull(this.localeResolver, (String)"localeResolver cannot be null.");
        Assert.notNull((Object)this.accountResolver, (String)"accountResolver cannot be null.");
        Assert.notNull((Object)this.contentNegotiationResolver, (String)"contentNegotiationResolver cannot be null or empty.");
    }

    protected Map<String, Object> newModel() {
        return new HashMap<String, Object>();
    }

    public abstract boolean isNotAllowedIfAuthenticated();

    protected String i18n(HttpServletRequest request, String key) {
        Locale locale = this.localeResolver.get(request, null);
        return this.messageSource.getMessage(key, locale);
    }

    protected String i18nWithDefault(HttpServletRequest request, String key, String defaultMessage) {
        Locale locale = this.localeResolver.get(request, null);
        return this.messageSource.getMessage(key, defaultMessage, locale);
    }

    protected String i18n(HttpServletRequest request, String key, Object ... args) {
        Locale locale = this.localeResolver.get(request, null);
        return this.messageSource.getMessage(key, locale, args);
    }

    protected boolean isJsonPreferred(HttpServletRequest request, HttpServletResponse response) {
        try {
            return MediaType.APPLICATION_JSON.equals(this.contentNegotiationResolver.getContentType(request, response, this.produces));
        }
        catch (UnresolvedMediaTypeException e) {
            log.debug("isJsonPreferred: Couldn't resolve content type: {}", (Object)e.getMessage());
            return false;
        }
    }

    protected boolean isHtmlPreferred(HttpServletRequest request, HttpServletResponse response) {
        try {
            return MediaType.TEXT_HTML.equals(this.contentNegotiationResolver.getContentType(request, response, this.produces));
        }
        catch (UnresolvedMediaTypeException e) {
            log.debug("isHtmlPreferred: Couldn't resolve content type: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public ViewModel handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String method = request.getMethod();
        boolean hasAccount = this.accountResolver.hasAccount((ServletRequest)request);
        if (HttpMethod.GET.name().equalsIgnoreCase(method)) {
            if (hasAccount && this.isNotAllowedIfAuthenticated()) {
                return new DefaultViewModel(this.nextUri).setRedirect(true);
            }
            return this.doGet(request, response);
        }
        if (HttpMethod.POST.name().equalsIgnoreCase(method)) {
            if (this.isNotAllowedIfAuthenticated() && hasAccount) {
                response.sendError(403);
                return null;
            }
            return this.doPost(request, response);
        }
        return this.service(request, response);
    }

    protected ViewModel service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        DEFAULT_HANDLER.service((ServletRequest)request, (ServletResponse)response);
        return null;
    }

    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.service(request, response);
    }

    protected ViewModel doPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.service(request, response);
    }

    protected String getNextUri(HttpServletRequest request) {
        String nextQueryParam = request.getParameter("next");
        if (Strings.hasText((String)nextQueryParam)) {
            return nextQueryParam;
        }
        return this.nextUri;
    }

    protected void publishRequestEvent(RequestEvent e) throws ServletException {
        if (e != null) {
            try {
                this.eventPublisher.publish(e);
            }
            catch (Exception ex) {
                String msg = "Unable to publish registered account request event: " + ex.getMessage();
                throw new ServletException(msg, (Throwable)ex);
            }
        }
    }

    protected Application getApplication(HttpServletRequest request) {
        return this.applicationResolver.getApplication((ServletRequest)request);
    }

    protected String exchangeGithubCodeForAccessToken(String code, HttpServletRequest request) {
        final DefaultGithubProvider[] githubProvider = new DefaultGithubProvider[1];
        for (ApplicationAccountStoreMapping mapping : this.getApplication(request).getAccountStoreMappings()) {
            AccountStore accountStore = mapping.getAccountStore();
            AccountStoreVisitorAdapter accountStoreVisitor = new AccountStoreVisitorAdapter(){

                public void visit(Directory directory) {
                    if ("github".equals(directory.getProvider().getProviderId())) {
                        githubProvider[0] = (DefaultGithubProvider)directory.getProvider();
                    }
                }
            };
            accountStore.accept((AccountStoreVisitor)accountStoreVisitor);
        }
        Assert.notNull((Object)githubProvider[0], (String)"githubProvider cannot be null.");
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            HttpPost httpPost = new HttpPost(GITHUB_ACCESS_TOKEN_URL);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("code", code));
            nvps.add(new BasicNameValuePair("client_id", githubProvider[0].getClientId()));
            nvps.add(new BasicNameValuePair("client_secret", githubProvider[0].getClientSecret()));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8.displayName()));
            httpPost.addHeader("Accept", "application/json");
            HttpResponse response = client.execute((HttpUriRequest)httpPost);
            ObjectMapper objectMapper = new ObjectMapper();
            Map result = (Map)objectMapper.readValue(response.getEntity().getContent(), Map.class);
            return (String)result.get(GITHUB_ACCESS_TOKEN_FIELD);
        }
        catch (Exception e) {
            log.error("Couldn't exchange GitHub oAuth code for an access token", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

