/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.impl.authc.DefaultBasicApiAuthenticationRequest;
import com.stormpath.sdk.impl.authc.DefaultHttpServletRequestWrapper;
import com.stormpath.sdk.impl.authc.HttpServletRequestWrapper;
import com.stormpath.sdk.impl.oauth.DefaultOAuthStormpathSocialGrantRequestAuthentication;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.AccessTokenResult;
import com.stormpath.sdk.oauth.Authenticators;
import com.stormpath.sdk.oauth.OAuthClientCredentialsGrantRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthClientCredentialsGrantRequestAuthenticationBuilder;
import com.stormpath.sdk.oauth.OAuthClientCredentialsGrantRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.oauth.OAuthStormpathSocialGrantRequestAuthenticator;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.authc.SuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.DefaultFailedAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.DefaultSuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authz.RequestAuthorizer;
import com.stormpath.sdk.servlet.event.RequestEvent;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.filter.oauth.AccessTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.AccessTokenResultFactory;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import com.stormpath.sdk.servlet.filter.oauth.OAuthException;
import com.stormpath.sdk.servlet.filter.oauth.RefreshTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.RefreshTokenResultFactory;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.http.authc.AuthorizationHeaderParser;
import com.stormpath.sdk.servlet.http.authc.DefaultAuthorizationHeaderParser;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationException;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationScheme;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenController.class);
    private static final String CLIENT_CREDENTIALS_GRANT_TYPE = "client_credentials";
    private static final String PASSWORD_GRANT_TYPE = "password";
    private static final String STORMPATH_SOCIAL_GRANT_TYPE = "stormpath_social";
    private static final String REFRESH_TOKEN_GRANT_TYPE = "refresh_token";
    private static final String GRANT_TYPE_PARAM_NAME = "grant_type";
    private RefreshTokenResultFactory refreshTokenResultFactory;
    private RefreshTokenAuthenticationRequestFactory refreshTokenAuthenticationRequestFactory;
    private RequestAuthorizer requestAuthorizer;
    private AccessTokenAuthenticationRequestFactory authenticationRequestFactory;
    private AccessTokenResultFactory resultFactory;
    private Saver<AuthenticationResult> accountSaver;
    private Publisher<RequestEvent> eventPublisher;
    private HttpAuthenticationScheme basicAuthenticationScheme;
    private final AuthorizationHeaderParser parser = new DefaultAuthorizationHeaderParser();

    public void setBasicAuthenticationScheme(HttpAuthenticationScheme basicAuthenticationScheme) {
        this.basicAuthenticationScheme = basicAuthenticationScheme;
    }

    public RequestAuthorizer getRequestAuthorizer() {
        return this.requestAuthorizer;
    }

    public void setRequestAuthorizer(RequestAuthorizer requestAuthorizer) {
        this.requestAuthorizer = requestAuthorizer;
    }

    public AccessTokenAuthenticationRequestFactory getAccessTokenAuthenticationRequestFactory() {
        return this.authenticationRequestFactory;
    }

    public void setAccessTokenAuthenticationRequestFactory(AccessTokenAuthenticationRequestFactory authenticationRequestFactory) {
        this.authenticationRequestFactory = authenticationRequestFactory;
    }

    public AccessTokenResultFactory getAccessTokenResultFactory() {
        return this.resultFactory;
    }

    public void setAccessTokenResultFactory(AccessTokenResultFactory resultFactory) {
        this.resultFactory = resultFactory;
    }

    public Saver<AuthenticationResult> getAccountSaver() {
        return this.accountSaver;
    }

    public void setAccountSaver(Saver<AuthenticationResult> accountSaver) {
        this.accountSaver = accountSaver;
    }

    @Override
    public Publisher<RequestEvent> getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public void setEventPublisher(Publisher<RequestEvent> eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public RefreshTokenResultFactory getRefreshTokenResultFactory() {
        return this.refreshTokenResultFactory;
    }

    public void setRefreshTokenResultFactory(RefreshTokenResultFactory refreshTokenResultFactory) {
        this.refreshTokenResultFactory = refreshTokenResultFactory;
    }

    public RefreshTokenAuthenticationRequestFactory getRefreshTokenAuthenticationRequestFactory() {
        return this.refreshTokenAuthenticationRequestFactory;
    }

    public void setRefreshTokenAuthenticationRequestFactory(RefreshTokenAuthenticationRequestFactory refreshTokenAuthenticationRequestFactory) {
        this.refreshTokenAuthenticationRequestFactory = refreshTokenAuthenticationRequestFactory;
    }

    @Override
    public void init() {
        Assert.notNull((Object)this.refreshTokenResultFactory, (String)"refreshTokenResultFactory cannot be null.");
        Assert.notNull((Object)this.refreshTokenAuthenticationRequestFactory, (String)"refreshTokenAuthenticationRequestFactory cannot be null.");
        Assert.notNull((Object)this.requestAuthorizer, (String)"requestAuthorizer cannot be null.");
        Assert.notNull((Object)this.authenticationRequestFactory, (String)"accessTokenAuthenticationRequestFactory cannot be null.");
        Assert.notNull((Object)this.resultFactory, (String)"accessTokenResultFactory cannot be null.");
        Assert.notNull(this.accountSaver, (String)"accountSaver cannot be null.");
        Assert.notNull(this.eventPublisher, (String)"eventPublisher cannot be null.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    @Override
    public ViewModel handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isClientCredentialsRequest = CLIENT_CREDENTIALS_GRANT_TYPE.equals(request.getParameter(GRANT_TYPE_PARAM_NAME));
        String method = request.getMethod();
        if (HttpMethod.POST.name().equalsIgnoreCase(method) && isClientCredentialsRequest) {
            return this.doPost(request, response);
        }
        return super.handleRequest(request, response);
    }

    protected void publish(RequestEvent e) {
        this.getEventPublisher().publish(e);
    }

    @Override
    protected Application getApplication(HttpServletRequest request) {
        Application application = (Application)request.getAttribute(Application.class.getName());
        Assert.notNull((Object)application, (String)"request must have an application attribute.");
        return application;
    }

    private AccessTokenResult tokenAuthenticationRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        OAuthGrantRequestAuthenticationResult authenticationResult;
        try {
            Application app = this.getApplication(request);
            OAuthPasswordGrantRequestAuthentication passwordGrantRequest = this.createPasswordGrantAuthenticationRequest(request);
            authenticationResult = (OAuthGrantRequestAuthenticationResult)((OAuthPasswordGrantRequestAuthenticator)Authenticators.OAUTH_PASSWORD_GRANT_REQUEST_AUTHENTICATOR.forApplication(app)).authenticate((OAuthRequestAuthentication)passwordGrantRequest);
        }
        catch (ResourceException e) {
            log.debug("Unable to authenticate access token request: {}", (Object)e.getMessage(), (Object)e);
            throw new OAuthException(OAuthErrorCode.INVALID_REQUEST, "Unable to authenticate access token request", (Exception)((Object)e));
        }
        return this.createAccessTokenResult(request, response, authenticationResult);
    }

    private AccessTokenResult refreshTokenAuthenticationRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        OAuthGrantRequestAuthenticationResult authenticationResult;
        try {
            Application app = this.getApplication(request);
            OAuthRefreshTokenRequestAuthentication refreshGrantRequest = this.createRefreshTokenAuthenticationRequest(request);
            authenticationResult = (OAuthGrantRequestAuthenticationResult)((OAuthRefreshTokenRequestAuthenticator)Authenticators.OAUTH_REFRESH_TOKEN_REQUEST_AUTHENTICATOR.forApplication(app)).authenticate((OAuthRequestAuthentication)refreshGrantRequest);
        }
        catch (ResourceException e) {
            log.debug("Unable to authenticate refresh token request: {}", (Object)e.getMessage(), (Object)e);
            throw new OAuthException(OAuthErrorCode.INVALID_GRANT, "Unable to authenticate refresh token request");
        }
        return this.createRefreshTokenResult(request, response, authenticationResult);
    }

    private AccessTokenResult clientCredentialsAuthenticationRequest(HttpServletRequest request, HttpServletResponse response) {
        OAuthGrantRequestAuthenticationResult authenticationResult;
        DefaultBasicApiAuthenticationRequest authenticationRequest = new DefaultBasicApiAuthenticationRequest((HttpServletRequestWrapper)new DefaultHttpServletRequestWrapper((Object)request));
        try {
            Application app = this.getApplication(request);
            OAuthClientCredentialsGrantRequestAuthentication clientCredentialsGrantRequestAuthentication = (OAuthClientCredentialsGrantRequestAuthentication)((OAuthClientCredentialsGrantRequestAuthenticationBuilder)OAuthRequests.OAUTH_CLIENT_CREDENTIALS_GRANT_REQUEST.builder()).setApiKeyId(authenticationRequest.getPrincipals()).setApiKeySecret(authenticationRequest.getCredentials()).build();
            authenticationResult = (OAuthGrantRequestAuthenticationResult)((OAuthClientCredentialsGrantRequestAuthenticator)Authenticators.OAUTH_CLIENT_CREDENTIALS_GRANT_REQUEST_AUTHENTICATOR.forApplication(app)).authenticate((OAuthRequestAuthentication)clientCredentialsGrantRequestAuthentication);
        }
        catch (ResourceException e) {
            log.debug("Unable to authenticate client credentials grant request: {}", (Object)e.getMessage(), (Object)e);
            throw new OAuthException(OAuthErrorCode.INVALID_CLIENT, "Unable to authenticate client credentials grant request");
        }
        return this.createAccessTokenResult(request, response, authenticationResult);
    }

    private AccessTokenResult stormpathSocialAuthenticationRequest(HttpServletRequest request, HttpServletResponse response) {
        OAuthGrantRequestAuthenticationResult authenticationResult;
        try {
            Application app = this.getApplication(request);
            String providerId = request.getParameter("providerId");
            String accessToken = request.getParameter("accessToken");
            String code = request.getParameter("code");
            DefaultOAuthStormpathSocialGrantRequestAuthentication grantRequestAuthentication = new DefaultOAuthStormpathSocialGrantRequestAuthentication(providerId, accessToken, code);
            authenticationResult = (OAuthGrantRequestAuthenticationResult)((OAuthStormpathSocialGrantRequestAuthenticator)Authenticators.OAUTH_STORMPATH_SOCIAL_GRANT_REQUEST_AUTHENTICATOR.forApplication(app)).authenticate((OAuthRequestAuthentication)grantRequestAuthentication);
        }
        catch (ResourceException e) {
            log.debug("Unable to authenticate stormpath social grant request: {}", (Object)e.getMessage(), (Object)e);
            throw new OAuthException(OAuthErrorCode.INVALID_CLIENT, "Unable to authenticate stormpath social grant request");
        }
        return this.createAccessTokenResult(request, response, authenticationResult);
    }

    @Override
    protected ViewModel doPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String json;
        AuthenticationRequest authcRequest = null;
        AccessTokenResult result = null;
        try {
            this.assertAuthorized(request, response);
            String grantType = null;
            try {
                grantType = request.getParameter(GRANT_TYPE_PARAM_NAME);
                Assert.hasText((String)grantType, (String)"grant_type must not be null or empty.");
            }
            catch (IllegalArgumentException e) {
                throw new OAuthException(OAuthErrorCode.INVALID_GRANT);
            }
            switch (grantType) {
                case "password": {
                    result = this.tokenAuthenticationRequest(request, response);
                    break;
                }
                case "refresh_token": {
                    result = this.refreshTokenAuthenticationRequest(request, response);
                    break;
                }
                case "client_credentials": {
                    try {
                        result = this.clientCredentialsAuthenticationRequest(request, response);
                        break;
                    }
                    catch (HttpAuthenticationException e) {
                        log.warn("Unable to authenticate client", (Throwable)e);
                        throw new OAuthException(OAuthErrorCode.INVALID_CLIENT);
                    }
                }
                case "stormpath_social": {
                    try {
                        result = this.stormpathSocialAuthenticationRequest(request, response);
                        break;
                    }
                    catch (HttpAuthenticationException e) {
                        log.warn("Unable to authenticate client", (Throwable)e);
                        throw new OAuthException(OAuthErrorCode.INVALID_CLIENT);
                    }
                }
                default: {
                    throw new OAuthException(OAuthErrorCode.UNSUPPORTED_GRANT_TYPE);
                }
            }
            this.saveResult(request, response, (AuthenticationResult)result);
            json = result.getTokenResponse().toJson();
            response.setStatus(200);
            Object e = this.createSuccessEvent(request, response, authcRequest, (AuthenticationResult)result);
            this.publish((RequestEvent)e);
        }
        catch (OAuthException e) {
            log.debug("OAuth Access Token request failed.", (Throwable)e);
            json = e.toJson();
            response.setStatus(400);
            if (e.getErrorCode().equals(OAuthErrorCode.INVALID_CLIENT)) {
                response.setStatus(401);
            }
            try {
                DefaultFailedAuthenticationRequestEvent evt = new DefaultFailedAuthenticationRequestEvent(request, response, authcRequest, e);
                this.publish(evt);
            }
            catch (Throwable t) {
                log.warn("Unable to publish failed authentication request event due to exception: {}. Ignoring and handling original authentication exception {}.", new Object[]{t, e, t});
            }
        }
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Content-Length", String.valueOf(json.length()));
        response.getWriter().print(json);
        response.getWriter().flush();
        return null;
    }

    protected SuccessfulAuthenticationRequestEvent createSuccessEvent(HttpServletRequest request, HttpServletResponse response, AuthenticationRequest authcRequest, AuthenticationResult result) {
        return new DefaultSuccessfulAuthenticationRequestEvent(request, response, authcRequest, result);
    }

    protected void saveResult(HttpServletRequest request, HttpServletResponse response, AuthenticationResult result) {
        this.getAccountSaver().set(request, response, result);
    }

    protected OAuthRefreshTokenRequestAuthentication createRefreshTokenAuthenticationRequest(HttpServletRequest request) throws OAuthException {
        return this.getRefreshTokenAuthenticationRequestFactory().createRefreshTokenAuthenticationRequest(request);
    }

    protected OAuthPasswordGrantRequestAuthentication createPasswordGrantAuthenticationRequest(HttpServletRequest request) throws OAuthException {
        return this.getAccessTokenAuthenticationRequestFactory().createAccessTokenAuthenticationRequest(request);
    }

    protected AccessTokenResult createRefreshTokenResult(HttpServletRequest request, HttpServletResponse response, OAuthGrantRequestAuthenticationResult result) {
        return this.getRefreshTokenResultFactory().createRefreshTokenResult(request, response, result);
    }

    protected void assertAuthorized(HttpServletRequest request, HttpServletResponse response) throws OAuthException {
        this.getRequestAuthorizer().assertAuthorized(request, response);
    }

    protected AccessTokenResult createAccessTokenResult(HttpServletRequest request, HttpServletResponse response, OAuthGrantRequestAuthenticationResult result) {
        return this.getAccessTokenResultFactory().createAccessTokenResult(request, response, result);
    }
}

