/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.form.DefaultField;
import com.stormpath.sdk.servlet.form.Field;
import com.stormpath.sdk.servlet.form.Form;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.mvc.AccountModelFactory;
import com.stormpath.sdk.servlet.mvc.ChangePasswordErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultAccountModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ErrorModel;
import com.stormpath.sdk.servlet.mvc.ErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.FormController;
import com.stormpath.sdk.servlet.mvc.MismatchedPasswordException;
import com.stormpath.sdk.servlet.mvc.RequestFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.ValidationException;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChangePasswordController
extends FormController {
    private String forgotPasswordUri;
    private String loginUri;
    private String loginNextUri;
    private String errorUri;
    private boolean autoLogin;
    private ErrorModelFactory errorModelFactory;
    private AccountModelFactory accountModelFactory;
    private Saver<AuthenticationResult> authenticationResultSaver;

    public void setForgotPasswordUri(String forgotPasswordUri) {
        this.forgotPasswordUri = forgotPasswordUri;
    }

    public void setLoginUri(String loginUri) {
        this.loginUri = loginUri;
    }

    public void setLoginNextUri(String loginNextUri) {
        this.loginNextUri = loginNextUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    public void setAutoLogin(boolean autoLogin) {
        this.autoLogin = autoLogin;
    }

    public void setErrorModelFactory(ErrorModelFactory errorModelFactory) {
        this.errorModelFactory = errorModelFactory;
    }

    public void setAccountModelFactory(AccountModelFactory accountModelFactory) {
        this.accountModelFactory = accountModelFactory;
    }

    public void setAuthenticationResultSaver(Saver<AuthenticationResult> authenticationResultSaver) {
        this.authenticationResultSaver = authenticationResultSaver;
    }

    @Override
    public void init() throws Exception {
        super.init();
        Assert.hasText((String)this.forgotPasswordUri, (String)"forgotPasswordUri cannot be null or empty.");
        Assert.hasText((String)this.loginUri, (String)"loginUri cannot be null or empty.");
        Assert.hasText((String)this.loginNextUri, (String)"loginNextUri cannot be null or empty.");
        Assert.hasText((String)this.errorUri, (String)"errorUri cannot be null or empty.");
        Assert.notNull(this.authenticationResultSaver, (String)"authenticationResultSaver cannot be null.");
        if (this.accountModelFactory == null) {
            this.accountModelFactory = new DefaultAccountModelFactory();
        }
        if (this.errorModelFactory == null) {
            this.errorModelFactory = new ChangePasswordErrorModelFactory(this.messageSource);
        }
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return false;
    }

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String sptoken = Strings.clean((String)request.getParameter("sptoken"));
        if (this.isJsonPreferred(request, response)) {
            Map<String, Object> model = new HashMap<String, Object>(1);
            if (sptoken == null) {
                model.put("status", 400);
                model.put("message", this.i18n(request, "stormpath.web.changePassword.form.errors.no_token"));
                response.setStatus(400);
            } else {
                try {
                    Application application = (Application)request.getAttribute(Application.class.getName());
                    application.verifyPasswordResetToken(sptoken);
                    response.setContentType("application/json");
                    return null;
                }
                catch (Exception e) {
                    model = this.errorModelFactory.toError(request, e).toMap();
                    response.setStatus(this.errorModelFactory.toError(request, e).getStatus());
                }
            }
            return new DefaultViewModel("stormpathJsonView", model);
        }
        if (sptoken == null) {
            return new DefaultViewModel(this.forgotPasswordUri).setRedirect(true);
        }
        try {
            Application application = (Application)request.getAttribute(Application.class.getName());
            application.verifyPasswordResetToken(sptoken);
        }
        catch (ResourceException re) {
            return new DefaultViewModel(this.errorUri).setRedirect(true);
        }
        return super.doGet(request, response);
    }

    @Override
    protected void appendModel(HttpServletRequest request, HttpServletResponse response, Form form, List<ErrorModel> errors, Map<String, Object> model) {
        model.put("loginUri", this.loginUri);
    }

    @Override
    protected List<Field> createFields(HttpServletRequest request, boolean retainPassword) {
        ArrayList<Field> fields = new ArrayList<Field>(3);
        RequestFieldValueResolver fieldValueResolver = this.getFieldValueResolver();
        String value = Strings.clean((String)fieldValueResolver.getValue(request, "sptoken"));
        if (value != null) {
            DefaultField field = new DefaultField();
            field.setName("sptoken");
            field.setType("hidden");
            field.setValue(value);
            fields.add(field);
        }
        String fieldName = "password";
        DefaultField field = new DefaultField();
        field.setName(fieldName);
        field.setLabel(this.i18n(request, "stormpath.web.changePassword.form.fields." + fieldName + ".label"));
        field.setPlaceholder(this.i18n(request, "stormpath.web.changePassword.form.fields." + fieldName + ".placeholder"));
        field.setRequired(true);
        field.setType("password");
        String val = fieldValueResolver.getValue(request, fieldName);
        field.setValue(retainPassword && val != null ? val : "");
        fields.add(field);
        return fields;
    }

    @Override
    protected List<ErrorModel> toErrors(HttpServletRequest request, Form form, Exception e) {
        ArrayList<ErrorModel> errors = new ArrayList<ErrorModel>(1);
        String errorMsg = this.i18n(request, "stormpath.web.changePassword.form.errors.default");
        int status = 400;
        if (e instanceof IllegalArgumentException || e instanceof MismatchedPasswordException || e instanceof ValidationException) {
            errorMsg = e.getMessage();
        } else if (e instanceof ResourceException && ((ResourceException)((Object)e)).getStatus() == 400) {
            errorMsg = this.i18n(request, "stormpath.web.changePassword.form.errors.strength");
        } else if (e instanceof ResourceException && ((ResourceException)((Object)e)).getStatus() == 404) {
            String url = request.getContextPath() + this.forgotPasswordUri;
            errorMsg = this.i18n(request, "stormpath.web.changePassword.form.errors.invalid", url);
        }
        errors.add(ErrorModel.builder().setMessage(errorMsg).setStatus(status).build());
        return errors;
    }

    @Override
    protected ViewModel onValidSubmit(HttpServletRequest request, HttpServletResponse response, Form form) throws Exception {
        String next;
        String password = form.getFieldValue("password");
        Application application = (Application)request.getAttribute(Application.class.getName());
        String sptoken = form.getFieldValue("sptoken");
        if (this.isJsonPreferred(request, response)) {
            Map<Object, Object> model = new HashMap();
            try {
                Account account = application.resetPassword(sptoken, password);
                if (!this.autoLogin) {
                    response.setContentType("application/json");
                    return null;
                }
                TransientAuthenticationResult result = new TransientAuthenticationResult(account);
                this.authenticationResultSaver.set(request, response, result);
                model.put("account", this.accountModelFactory.toMap(account, Collections.EMPTY_LIST));
            }
            catch (Exception e) {
                model = this.errorModelFactory.toError(request, e).toMap();
                response.setStatus(this.errorModelFactory.toError(request, e).getStatus());
            }
            return new DefaultViewModel("stormpathJsonView", model);
        }
        try {
            Account account = application.resetPassword(sptoken, password);
            if (this.autoLogin) {
                TransientAuthenticationResult result = new TransientAuthenticationResult(account);
                this.authenticationResultSaver.set(request, response, result);
                next = this.loginNextUri;
            } else {
                next = this.nextUri;
            }
        }
        catch (Exception e) {
            next = this.errorUri;
        }
        return new DefaultViewModel(next).setRedirect(true);
    }

    @Override
    protected void validate(HttpServletRequest request, HttpServletResponse response, Form form) {
        if (this.isJsonPreferred(request, response)) {
            String password = form.getFieldValue("password");
            if (password == null || password.isEmpty()) {
                String key = "stormpath.web.changePassword.form.fields.password.required";
                String msg = this.i18n(request, key);
                throw new ValidationException(msg);
            }
            String sptoken = form.getFieldValue("sptoken");
            if (sptoken == null || sptoken.isEmpty()) {
                String key = "stormpath.web.changePassword.form.errors.no_token";
                String msg = this.i18n(request, key);
                throw new ValidationException(msg);
            }
        } else {
            super.validate(request, response, form);
        }
    }
}

