/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.impl.account.DefaultAccount;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.impl.resource.DateProperty;
import com.stormpath.sdk.impl.resource.EnumProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.resource.CollectionResource;
import com.stormpath.sdk.servlet.mvc.AccountModelFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccountModelFactory
implements AccountModelFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultAccountModelFactory.class);

    @Override
    public Map<String, Object> toMap(Account account, List<String> expands) {
        Assert.notNull((Object)account, (String)"account cannot be null");
        DefaultAccount defaultAccount = (DefaultAccount)account;
        Map<String, Object> accountMap = this.getResourceProperties((AbstractResource)defaultAccount);
        for (String property : expands) {
            if (!defaultAccount.getPropertyDescriptors().containsKey(property)) continue;
            try {
                Method method = defaultAccount.getClass().getMethod("get" + Strings.capitalize((String)property), new Class[0]);
                Object propertyValue = method.invoke((Object)account, new Object[0]);
                if (propertyValue instanceof CollectionResource) {
                    ArrayList<Map<String, Object>> resourcesMap = new ArrayList<Map<String, Object>>();
                    CollectionResource collectionResource = (CollectionResource)propertyValue;
                    Iterator iterator = collectionResource.iterator();
                    while (iterator.hasNext()) {
                        resourcesMap.add(this.getResourceProperties((AbstractResource)iterator.next()));
                    }
                    LinkedHashMap<String, ArrayList<Map<String, Object>>> items = new LinkedHashMap<String, ArrayList<Map<String, Object>>>();
                    items.put("items", resourcesMap);
                    accountMap.put(property, items);
                    continue;
                }
                if (!(propertyValue instanceof AbstractResource)) continue;
                if ("customData".equals(property)) {
                    accountMap.put(property, account.getCustomData());
                    continue;
                }
                accountMap.put(property, this.getResourceProperties((AbstractResource)propertyValue));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Error expanding account property", (Throwable)e);
            }
        }
        return accountMap;
    }

    public Map<String, Object> getResourceProperties(AbstractResource resource) {
        LinkedHashMap<String, Object> resourceProperties = new LinkedHashMap<String, Object>();
        resourceProperties.put("href", resource.getHref());
        resourceProperties.put("createdAt", resource.getProperty("createdAt"));
        resourceProperties.put("modifiedAt", resource.getProperty("modifiedAt"));
        for (Property property : resource.getPropertyDescriptors().values()) {
            if (!(property instanceof StringProperty) && !(property instanceof DateProperty) && !(property instanceof EnumProperty) || "password".equals(property.getName())) continue;
            resourceProperties.put(property.getName(), resource.getProperty(property.getName()));
        }
        return resourceProperties;
    }
}

