/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.provider.FacebookAccountRequestBuilder;
import com.stormpath.sdk.provider.GithubAccountRequestBuilder;
import com.stormpath.sdk.provider.GoogleAccountRequestBuilder;
import com.stormpath.sdk.provider.LinkedInAccountRequestBuilder;
import com.stormpath.sdk.provider.ProviderAccountRequest;
import com.stormpath.sdk.provider.ProviderAccountResult;
import com.stormpath.sdk.provider.Providers;
import com.stormpath.sdk.servlet.csrf.CsrfTokenManager;
import com.stormpath.sdk.servlet.csrf.DisabledCsrfTokenManager;
import com.stormpath.sdk.servlet.form.DefaultField;
import com.stormpath.sdk.servlet.form.DefaultForm;
import com.stormpath.sdk.servlet.form.Field;
import com.stormpath.sdk.servlet.form.Form;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ErrorModel;
import com.stormpath.sdk.servlet.mvc.JacksonFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.RequestFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.ValidationException;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(FormController.class);
    public static final String SPRING_SECURITY_AUTHENTICATION_FAILED_KEY = "SPRING_SECURITY_AUTHENTICATION_FAILED_MESSAGE";
    private CsrfTokenManager csrfTokenManager;
    private RequestFieldValueResolver fieldValueResolver;
    private List<Field> formFields;

    public void setCsrfTokenManager(CsrfTokenManager csrfTokenManager) {
        this.csrfTokenManager = csrfTokenManager;
    }

    public void setFieldValueResolver(RequestFieldValueResolver fieldValueResolver) {
        this.fieldValueResolver = fieldValueResolver;
    }

    protected RequestFieldValueResolver getFieldValueResolver() {
        return this.fieldValueResolver;
    }

    public void setFormFields(List<Field> formFields) {
        this.formFields = formFields;
    }

    protected CsrfTokenManager getCsrfTokenManager() {
        return this.csrfTokenManager;
    }

    @Override
    public void init() throws Exception {
        super.init();
        Assert.notNull((Object)this.csrfTokenManager, (String)"csrfTokenManager cannot be null.");
        Assert.notNull((Object)this.fieldValueResolver, (String)"fieldValueResolver cannot be null.");
    }

    private boolean isCsrfProtectionEnabled() {
        return this.csrfTokenManager != null && !(this.csrfTokenManager instanceof DisabledCsrfTokenManager);
    }

    protected Field createCsrfTokenField(String value) {
        return DefaultField.builder().setName(this.csrfTokenManager.getTokenName()).setValue(value).setType("hidden").build();
    }

    protected void setCsrfToken(HttpServletRequest request, HttpServletResponse response, Form form) throws IllegalArgumentException {
        if (!this.isJsonPreferred(request, response)) {
            Assert.isInstanceOf(DefaultForm.class, (Object)form, (String)"Form implementation class must equal or extend DefaultForm");
            String val = this.fieldValueResolver.getValue(request, this.csrfTokenManager.getTokenName());
            if (HttpMethod.POST.name().equalsIgnoreCase(request.getMethod())) {
                form.addField(this.createCsrfTokenField(val));
            } else if (HttpMethod.GET.name().equalsIgnoreCase(request.getMethod())) {
                form.addField(this.createCsrfTokenField(this.csrfTokenManager.createCsrfToken(request, response)));
            }
        }
    }

    void validateCsrfToken(HttpServletRequest request, HttpServletResponse response, Form form) throws IllegalArgumentException {
        if (this.isCsrfProtectionEnabled() && !this.isJsonPreferred(request, response)) {
            String csrfToken = form.getFieldValue(this.csrfTokenManager.getTokenName());
            Assert.isTrue((boolean)this.csrfTokenManager.isValidCsrfToken(request, response, csrfToken), (String)"Invalid CSRF token");
            form.getField(this.csrfTokenManager.getTokenName()).setValue(this.csrfTokenManager.createCsrfToken(request, response));
        }
    }

    private void setForm(Map<String, Object> model, Form form) {
        model.put("form", form);
    }

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, ?> model = this.createModel(request, response);
        return new DefaultViewModel(this.view, model);
    }

    protected Map<String, ?> createModel(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<ErrorModel> errors = null;
        if (request.getParameter("error") != null && request.getSession(false) != null) {
            errors = new ArrayList<ErrorModel>();
            ErrorModel error = (ErrorModel)request.getSession(false).getAttribute(SPRING_SECURITY_AUTHENTICATION_FAILED_KEY);
            if (error != null) {
                errors.add(error);
            }
        }
        return this.createModel(request, response, null, errors);
    }

    protected Map<String, ?> createModel(HttpServletRequest request, HttpServletResponse response, Form form, List<ErrorModel> errors) {
        Map<String, Object> model = this.newModel();
        if (!Collections.isEmpty(errors)) {
            model.put("errors", errors);
        }
        if (form == null) {
            form = this.createForm(request, response);
        }
        this.setForm(model, form);
        String status = Strings.clean((String)request.getParameter("status"));
        if (status != null) {
            model.put("status", status);
        }
        this.appendModel(request, response, form, errors, model);
        return model;
    }

    protected Form createForm(HttpServletRequest request, HttpServletResponse response) {
        return this.createForm(request, response, false);
    }

    protected Form createForm(HttpServletRequest request, HttpServletResponse response, boolean retainPassword) {
        DefaultForm form = DefaultForm.builder().setFields(this.createFields(request, retainPassword)).build();
        if (this.isCsrfProtectionEnabled()) {
            this.setCsrfToken(request, response, form);
        }
        return form;
    }

    protected List<Field> createFields(HttpServletRequest request, boolean retainPassword) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field templateField : this.formFields) {
            Field clone = templateField.copy();
            if (!clone.isEnabled()) continue;
            String val = this.fieldValueResolver.getValue(request, clone.getName());
            if (retainPassword && "password".equals(clone.getName())) {
                clone.setValue(val);
            } else {
                clone.setValue(val);
            }
            ((DefaultField)clone).setLabel(this.i18nWithDefault(request, clone.getLabel(), clone.getLabel()));
            ((DefaultField)clone).setPlaceholder(this.i18nWithDefault(request, clone.getPlaceholder(), clone.getPlaceholder()));
            fields.add(clone);
        }
        return fields;
    }

    protected void appendModel(HttpServletRequest request, HttpServletResponse response, Form form, List<ErrorModel> errors, Map<String, Object> model) {
    }

    @Override
    protected ViewModel doPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Form form = this.createForm(request, response, true);
        try {
            this.validate(request, response, form);
            return this.onValidSubmit(request, response, form);
        }
        catch (Exception e) {
            return this.onErrorSubmit(request, response, form, e);
        }
    }

    protected ViewModel onErrorSubmit(HttpServletRequest request, HttpServletResponse response, Form form, Exception e) {
        this.sanitizeForm(form);
        List<ErrorModel> errors = this.toErrors(request, form, e);
        if (this.isJsonPreferred(request, response)) {
            response.setStatus(errors.get(0).getStatus());
            return new DefaultViewModel("stormpathJsonView", errors.get(0).toMap());
        }
        Map<String, ?> model = this.createModel(request, response, form, errors);
        return new DefaultViewModel(this.view, model);
    }

    private void sanitizeForm(Form form) {
        Field field = form.getField("password");
        if (field != null) {
            field.setValue("");
        }
        if ((field = form.getField("confirmPassword")) != null) {
            field.setValue("");
        }
    }

    protected abstract List<ErrorModel> toErrors(HttpServletRequest var1, Form var2, Exception var3);

    protected abstract ViewModel onValidSubmit(HttpServletRequest var1, HttpServletResponse var2, Form var3) throws Exception;

    protected void validate(HttpServletRequest request, HttpServletResponse response, Form form) {
        ProviderAccountResult result;
        Account account;
        ProviderAccountRequest accountRequest;
        this.validateCsrfToken(request, response, form);
        if (request.getParameterMap().size() == 0 && request.getContentLength() > 0 && (accountRequest = this.getAccountProviderRequest(request)) != null && (account = (result = this.getApplication(request).getAccount(accountRequest)).getAccount()).getStatus().equals((Object)AccountStatus.ENABLED)) {
            request.setAttribute(Account.class.getName(), (Object)account);
            return;
        }
        List<Field> fields = form.getFields();
        for (Field field : fields) {
            String value;
            if (!field.isRequired() && !field.isEnabled() || (value = form.getFieldValue(field.getName())) != null) continue;
            String key = "stormpath.web." + this.getControllerKey() + ".form.fields." + field.getName() + ".required";
            String msg = this.i18n(request, key);
            throw new ValidationException(msg);
        }
        if (this.isJsonPreferred(request, response)) {
            Map<String, Object> postedJsonFields = this.fieldValueResolver.getAllFields(request);
            for (String fieldName : postedJsonFields.keySet()) {
                if (form.getField(fieldName) != null || "customData".equals(fieldName)) continue;
                String key = "stormpath.web.form.fields.unknown";
                String msg = this.i18n(request, key, fieldName);
                throw new ValidationException(msg);
            }
        }
    }

    private ProviderAccountRequest getAccountProviderRequest(HttpServletRequest request) {
        Map map = (Map)request.getAttribute(JacksonFieldValueResolver.MARSHALLED_OBJECT);
        Map providerData = (Map)map.get("providerData");
        if (providerData != null) {
            String providerId = (String)providerData.get("providerId");
            ProviderAccountRequest accountRequest = null;
            switch (providerId) {
                case "facebook": {
                    String accessToken = (String)providerData.get("accessToken");
                    accountRequest = ((FacebookAccountRequestBuilder)((FacebookAccountRequestBuilder)Providers.FACEBOOK.account()).setAccessToken(accessToken)).build();
                    break;
                }
                case "github": {
                    String code = (String)providerData.get("code");
                    accountRequest = ((GithubAccountRequestBuilder)((GithubAccountRequestBuilder)Providers.GITHUB.account()).setAccessToken(this.exchangeGithubCodeForAccessToken(code, request))).build();
                    break;
                }
                case "google": {
                    String code = (String)providerData.get("code");
                    accountRequest = ((GoogleAccountRequestBuilder)Providers.GOOGLE.account()).setCode(code).build();
                    break;
                }
                case "linkedin": {
                    String code = (String)providerData.get("code");
                    accountRequest = ((LinkedInAccountRequestBuilder)Providers.LINKEDIN.account()).setCode(code).build();
                    break;
                }
                default: {
                    log.error("No provider configured for " + providerId);
                }
            }
            return accountRequest;
        }
        log.warn("Provider data not found in request.");
        return null;
    }
}

