/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.idsite.IdSiteUrlBuilder;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.filter.ServerUriResolver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.idsite.IdSiteOrganizationContext;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IdSiteController
extends AbstractController {
    private ServerUriResolver serverUriResolver;
    private String callbackUri;
    private String idSiteUri;
    private String alreadyLoggedInUri = null;
    private Resolver<IdSiteOrganizationContext> idSiteOrganizationResolver;

    public void setServerUriResolver(ServerUriResolver serverUriResolver) {
        this.serverUriResolver = serverUriResolver;
    }

    public void setCallbackUri(String callbackUri) {
        this.callbackUri = callbackUri;
    }

    public void setIdSiteUri(String idSiteUri) {
        this.idSiteUri = idSiteUri;
    }

    public void setAlreadyLoggedInUri(String alreadyLoggedInUri) {
        this.alreadyLoggedInUri = alreadyLoggedInUri;
    }

    public void setIdSiteOrganizationResolver(Resolver<IdSiteOrganizationContext> idSiteOrganizationResolver) {
        this.idSiteOrganizationResolver = idSiteOrganizationResolver;
    }

    @Override
    public void init() {
        Assert.notNull((Object)this.serverUriResolver, (String)"serverUriResolver must be configured.");
        Assert.notNull((Object)this.callbackUri, (String)"callbackUri must be configured.");
        Assert.notNull(this.idSiteOrganizationResolver, (String)"idSiteOrganizationResolver must be configured.");
        Assert.notNull((Object)this.alreadyLoggedInUri, (String)"alreadyLoggedInUri must be configured.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return false;
    }

    @Override
    protected Application getApplication(HttpServletRequest request) {
        return ApplicationResolver.INSTANCE.getApplication((ServletRequest)request);
    }

    protected String buildCallbackUri(HttpServletRequest request) {
        String uri = this.serverUriResolver.getServerUri(request);
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = "";
        }
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        uri = uri + contextPath + this.callbackUri;
        return uri;
    }

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (AccountResolver.INSTANCE.getAccount((ServletRequest)request) != null) {
            return new DefaultViewModel(this.alreadyLoggedInUri).setRedirect(true);
        }
        String idSiteUrl = this.createIdSiteUrl(request);
        response.setHeader("Cache-control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
        return new DefaultViewModel(idSiteUrl).setRedirect(true);
    }

    protected String createIdSiteUrl(HttpServletRequest request) {
        IdSiteUrlBuilder builder = this.createIdSiteUrlBuilder(request);
        return builder.build();
    }

    protected IdSiteUrlBuilder createIdSiteUrlBuilder(HttpServletRequest request) {
        Application application = this.getApplication(request);
        String callbackUri = this.buildCallbackUri(request);
        IdSiteUrlBuilder builder = application.newIdSiteUrlBuilder().setCallbackUri(callbackUri);
        IdSiteOrganizationContext orgCtx = this.idSiteOrganizationResolver.get(request, null);
        if (orgCtx != null) {
            Boolean val;
            String nameKey = orgCtx.getOrganizationNameKey();
            if (Strings.hasText((String)nameKey)) {
                builder.setOrganizationNameKey(nameKey);
                val = orgCtx.isUseSubdomain();
                if (val != null) {
                    builder.setUseSubdomain(orgCtx.isUseSubdomain().booleanValue());
                }
            }
            if ((val = orgCtx.isShowOrganizationField()) != null) {
                builder.setShowOrganizationField(val.booleanValue());
            }
        }
        if (this.idSiteUri != null) {
            builder.setPath(this.idSiteUri);
        }
        return builder;
    }
}

