/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.idsite.IdSiteUrlBuilder;
import com.stormpath.sdk.idsite.LogoutResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.ServerUriResolver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.idsite.IdSiteOrganizationContext;
import com.stormpath.sdk.servlet.mvc.Controller;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.IdSiteController;
import com.stormpath.sdk.servlet.mvc.LogoutController;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IdSiteLogoutController
extends LogoutController {
    private ServerUriResolver serverUriResolver;
    private String idSiteResultUri;
    private Resolver<IdSiteOrganizationContext> idSiteOrganizationResolver;
    private Controller idSiteController;

    public void setServerUriResolver(ServerUriResolver serverUriResolver) {
        this.serverUriResolver = serverUriResolver;
    }

    public void setIdSiteResultUri(String idSiteResultUri) {
        this.idSiteResultUri = idSiteResultUri;
    }

    public void setIdSiteOrganizationResolver(Resolver<IdSiteOrganizationContext> idSiteOrganizationResolver) {
        this.idSiteOrganizationResolver = idSiteOrganizationResolver;
    }

    @Override
    public void init() {
        super.init();
        Assert.notNull((Object)this.serverUriResolver, (String)"serverUriResolver must be configured.");
        Assert.hasText((String)this.idSiteResultUri, (String)"idSiteResultUri must be configured.");
        Assert.notNull(this.idSiteOrganizationResolver, (String)"idSiteOrganizationController must be configured.");
        LogoutIdSiteController controller = new LogoutIdSiteController();
        controller.setAlreadyLoggedInUri(this.nextUri);
        controller.setServerUriResolver(this.serverUriResolver);
        controller.setCallbackUri(this.idSiteResultUri);
        controller.setIdSiteOrganizationResolver(this.idSiteOrganizationResolver);
        controller.init();
        this.idSiteController = controller;
    }

    @Override
    public ViewModel handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getAttribute(LogoutResult.class.getName()) != null) {
            return new DefaultViewModel(this.nextUri).setRedirect(true);
        }
        super.handleRequest(request, response);
        return this.idSiteController.handleRequest(request, response);
    }

    private static class LogoutIdSiteController
    extends IdSiteController {
        private LogoutIdSiteController() {
        }

        @Override
        protected IdSiteUrlBuilder createIdSiteUrlBuilder(HttpServletRequest request) {
            return super.createIdSiteUrlBuilder(request).forLogout();
        }

        @Override
        protected ViewModel doPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
            String idSiteUrl = this.createIdSiteUrl(request);
            response.setHeader("Cache-control", "no-cache, no-store");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "-1");
            return new DefaultViewModel(idSiteUrl).setRedirect(true);
        }
    }
}

