/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.idsite.AuthenticationResult;
import com.stormpath.sdk.idsite.IdSiteCallbackHandler;
import com.stormpath.sdk.idsite.IdSiteResultListener;
import com.stormpath.sdk.idsite.LogoutResult;
import com.stormpath.sdk.idsite.RegistrationResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.account.event.RegisteredAccountRequestEvent;
import com.stormpath.sdk.servlet.account.event.impl.DefaultRegisteredAccountRequestEvent;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.mvc.CallbackController;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IdSiteResultController
extends CallbackController {
    private String registerNextUri = null;
    private List<IdSiteResultListener> idSiteResultListeners = new ArrayList<IdSiteResultListener>();

    public void addIdSiteResultListener(IdSiteResultListener resultListener) {
        Assert.notNull((Object)resultListener, (String)"resultListener cannot be null");
        this.idSiteResultListeners.add(resultListener);
    }

    @Override
    public void doInit() {
        Assert.notNull((Object)this.registerNextUri, (String)"registerNextUri must be configured.");
    }

    public void setRegisterNextUri(String registerNextUri) {
        this.registerNextUri = registerNextUri;
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    @Override
    protected Application getApplication(HttpServletRequest request) {
        return ApplicationResolver.INSTANCE.getApplication((ServletRequest)request);
    }

    @Override
    protected ViewModel doGet(final HttpServletRequest request, final HttpServletResponse response) throws Exception {
        Application app = this.getApplication(request);
        final ViewModel[] viewModel = new ViewModel[1];
        IdSiteCallbackHandler idSiteCallbackHandler = app.newIdSiteCallbackHandler((Object)request).setResultListener(new IdSiteResultListener(){

            public void onRegistered(RegistrationResult result) {
                viewModel[0] = IdSiteResultController.this.onRegistration(request, response, result);
            }

            public void onAuthenticated(AuthenticationResult result) {
                viewModel[0] = IdSiteResultController.this.onAuthentication(request, response, result);
            }

            public void onLogout(LogoutResult result) {
                viewModel[0] = IdSiteResultController.this.onLogout(request, response, result);
            }
        });
        for (IdSiteResultListener resultListener : this.idSiteResultListeners) {
            idSiteCallbackHandler.addResultListener(resultListener);
        }
        idSiteCallbackHandler.getAccountResult();
        return viewModel[0];
    }

    private ViewModel onRegistration(HttpServletRequest request, HttpServletResponse response, RegistrationResult result) {
        Account account = result.getAccount();
        AccountStatus status = account.getStatus();
        RegisteredAccountRequestEvent e = this.createRegisteredEvent(request, response, account);
        this.publish(e);
        if (status == AccountStatus.ENABLED) {
            TransientAuthenticationResult authcResult = new TransientAuthenticationResult(account);
            this.saveResult(request, response, authcResult);
        }
        return new DefaultViewModel(this.registerNextUri).setRedirect(true);
    }

    private RegisteredAccountRequestEvent createRegisteredEvent(HttpServletRequest request, HttpServletResponse response, Account account) {
        return new DefaultRegisteredAccountRequestEvent(request, response, account);
    }
}

