/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.mvc.RequestFieldValueResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class JacksonFieldValueResolver
implements RequestFieldValueResolver {
    protected static final String MARSHALLED_OBJECT = JacksonFieldValueResolver.class.getName() + ".MARSHALLED_OBJECT";
    ObjectMapper objectMapper = new ObjectMapper();

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String getValue(HttpServletRequest request, String fieldName) {
        Map<String, Object> map = this.ensureBodyMap(request);
        Object value = map.get(fieldName);
        return value != null ? Strings.clean((String)value.toString()) : null;
    }

    @Override
    public Map<String, Object> getAllFields(HttpServletRequest request) {
        return this.ensureBodyMap(request);
    }

    private Map<String, Object> ensureBodyMap(HttpServletRequest request) {
        Map<String, Object> map = (Map<String, Object>)request.getAttribute(MARSHALLED_OBJECT);
        if (map == null) {
            boolean bodyExists;
            map = Collections.emptyMap();
            boolean bl = bodyExists = request.getContentLength() > 0 || request.getHeader("Transfer-Encoding") != null;
            if (bodyExists) {
                map = this.readJsonBody(request);
            }
            request.setAttribute(MARSHALLED_OBJECT, map);
        }
        return map;
    }

    private Map<String, Object> readJsonBody(HttpServletRequest request) {
        try {
            return (Map)this.getObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        }
        catch (IOException e) {
            String msg = "Unable to read JSON value from request body: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

