/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.servlet.mvc.View;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JacksonView
implements View {
    private ObjectMapper objectMapper = new ObjectMapper();
    private JsonEncoding encoding = JsonEncoding.UTF8;
    private String contentType = "application/json";
    private boolean updateContentLength = false;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isUpdateContentLength() {
        return this.updateContentLength;
    }

    public void setUpdateContentLength(boolean updateContentLength) {
        this.updateContentLength = updateContentLength;
    }

    public JsonEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(JsonEncoding encoding) {
        this.encoding = encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void render(HttpServletRequest request, HttpServletResponse response, ViewModel model) throws Exception {
        response.setContentType(this.getContentType());
        OutputStream stream = this.updateContentLength ? this.createTemporaryOutputStream() : response.getOutputStream();
        Object value = this.finalizeContent(model, request);
        this.writeContent(stream, value);
        if (this.updateContentLength) {
            assert (stream instanceof ByteArrayOutputStream);
            this.writeToResponse(response, (ByteArrayOutputStream)stream);
        }
    }

    protected void writeToResponse(HttpServletResponse response, ByteArrayOutputStream baos) throws IOException {
        response.setContentLength(baos.size());
        ServletOutputStream out = response.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.flush();
    }

    protected Object finalizeContent(ViewModel model, HttpServletRequest request) {
        return model.getModel();
    }

    protected void writeContent(OutputStream stream, Object content) throws IOException {
        JsonGenerator generator = this.objectMapper.getFactory().createGenerator(stream, this.encoding);
        this.objectMapper.writeValue(generator, content);
        generator.flush();
    }

    private OutputStream createTemporaryOutputStream() {
        return new ByteArrayOutputStream(4096);
    }
}

