/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.filter.LoginPageRedirector;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.AccountModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultAccountModelFactory;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MeController
extends AbstractController {
    private List<String> expands;
    private AccountModelFactory accountModelFactory = new DefaultAccountModelFactory();
    private ObjectMapper objectMapper;
    private LoginPageRedirector loginPageRedirector;

    @Override
    public void init() throws Exception {
        Assert.hasText((String)this.uri, (String)"uri cannot be null or empty.");
        Assert.notNull((Object)this.accountModelFactory, (String)"accountModelFactory cannot be null.");
        Assert.notNull((Object)this.objectMapper, (String)"objectMapper cannot be null.");
        Assert.notEmpty((Collection)this.produces, (String)"produces cannot be null or empty");
        Assert.notNull((Object)this.applicationResolver, (String)"applicationResolver cannot be null.");
    }

    public LoginPageRedirector getLoginPageRedirector() {
        return this.loginPageRedirector;
    }

    public void setLoginPageRedirector(LoginPageRedirector loginPageRedirector) {
        this.loginPageRedirector = loginPageRedirector;
    }

    public List<String> getExpands() {
        return this.expands;
    }

    public void setExpands(List<String> expands) {
        this.expands = expands;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return false;
    }

    @Override
    protected ViewModel doPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.doGet(request, response);
    }

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Account account = AccountResolver.INSTANCE.getAccount((ServletRequest)request);
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("application/json");
        if (account == null) {
            if (this.isHtmlPreferred(request, response)) {
                this.loginPageRedirector.redirectToLoginPage(request, response);
            }
            if (this.isJsonPreferred(request, response)) {
                Application application = this.applicationResolver.getApplication(request.getServletContext());
                String bearerRealm = String.format("Bearer realm=\"%s\"", application.getName());
                response.addHeader("WWW-Authenticate", bearerRealm);
                response.setStatus(401);
            }
            return null;
        }
        this.objectMapper.writeValue((OutputStream)response.getOutputStream(), Collections.singletonMap("account", this.accountModelFactory.toMap(account, this.expands)));
        return null;
    }
}

