/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.AccountStoreVisitorAdapter;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.servlet.account.event.impl.DefaultRegisteredAccountRequestEvent;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.form.Field;
import com.stormpath.sdk.servlet.form.Form;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.http.authc.AccountStoreResolver;
import com.stormpath.sdk.servlet.mvc.AccountModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultAccountModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ErrorModel;
import com.stormpath.sdk.servlet.mvc.ErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.FormController;
import com.stormpath.sdk.servlet.mvc.MismatchedPasswordException;
import com.stormpath.sdk.servlet.mvc.RegisterErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.mvc.WebHandler;
import com.stormpath.sdk.servlet.mvc.provider.AccountStoreModelFactory;
import com.stormpath.sdk.servlet.mvc.provider.ExternalAccountStoreModelFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterController
extends FormController {
    private static final Logger log = LoggerFactory.getLogger(RegisterController.class);
    public static final List<String> ACCOUNT_PROPERTIES = Collections.unmodifiableList(Arrays.asList("email", "username", "password", "givenName", "middleName", "surname"));
    private boolean autoLogin;
    private String loginUri;
    private String verifyViewName;
    private Client client;
    private Saver<AuthenticationResult> authenticationResultSaver;
    private AccountModelFactory accountModelFactory;
    private AccountStoreModelFactory accountStoreModelFactory;
    private ErrorModelFactory errorModelFactory;
    private WebHandler preRegisterHandler;
    private WebHandler postRegisterHandler;
    private AccountStoreResolver accountStoreResolver;

    public void setAutoLogin(boolean autoLogin) {
        this.autoLogin = autoLogin;
    }

    public void setLoginUri(String loginUri) {
        this.loginUri = loginUri;
    }

    public void setVerifyViewName(String verifyViewName) {
        this.verifyViewName = verifyViewName;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setAuthenticationResultSaver(Saver<AuthenticationResult> authenticationResultSaver) {
        this.authenticationResultSaver = authenticationResultSaver;
    }

    public void setAccountModelFactory(AccountModelFactory accountModelFactory) {
        this.accountModelFactory = accountModelFactory;
    }

    public void setAccountStoreModelFactory(AccountStoreModelFactory accountStoreModelFactory) {
        this.accountStoreModelFactory = accountStoreModelFactory;
    }

    public void setErrorModelFactory(ErrorModelFactory errorModelFactory) {
        this.errorModelFactory = errorModelFactory;
    }

    public void setPreRegisterHandler(WebHandler preRegisterHandler) {
        this.preRegisterHandler = preRegisterHandler;
    }

    public void setPostRegisterHandler(WebHandler postRegisterHandler) {
        this.postRegisterHandler = postRegisterHandler;
    }

    public AccountStoreResolver getAccountStoreResolver() {
        return this.accountStoreResolver;
    }

    public void setAccountStoreResolver(AccountStoreResolver accountStoreResolver) {
        this.accountStoreResolver = accountStoreResolver;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.accountModelFactory == null) {
            this.accountModelFactory = new DefaultAccountModelFactory();
        }
        if (this.accountStoreModelFactory == null) {
            this.accountStoreModelFactory = new ExternalAccountStoreModelFactory();
        }
        if (this.errorModelFactory == null) {
            this.errorModelFactory = new RegisterErrorModelFactory(this.messageSource);
        }
        Assert.notNull((Object)this.client, (String)"client cannot be null.");
        Assert.notNull(this.authenticationResultSaver, (String)"authenticationResultSaver cannot be null.");
        Assert.hasText((String)this.loginUri, (String)"loginUri cannot be null or empty.");
        Assert.hasText((String)this.verifyViewName, (String)"verifyViewName cannot be null or empty.");
        Assert.notNull((Object)this.preRegisterHandler, (String)"preRegisterHandler cannot be null.");
        Assert.notNull((Object)this.postRegisterHandler, (String)"postRegisterHandler cannot be null.");
        Assert.notNull((Object)this.accountModelFactory, (String)"accountModelFactory cannot be null.");
        Assert.notNull((Object)this.accountStoreModelFactory, (String)"accountStoreModelFactory cannot be null.");
        Assert.notNull((Object)this.errorModelFactory, (String)"errorModelFactory cannot be null.");
        Assert.notNull((Object)this.accountStoreResolver, (String)"accountStoreResolver cannot be null.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    @Override
    protected void appendModel(HttpServletRequest request, HttpServletResponse response, Form form, List<ErrorModel> errors, Map<String, Object> model) {
        if (!this.isJsonPreferred(request, response)) {
            model.put("loginUri", this.loginUri);
        } else {
            model.put("accountStores", this.accountStoreModelFactory.getAccountStores(request));
        }
    }

    @Override
    protected List<ErrorModel> toErrors(HttpServletRequest request, Form form, Exception e) {
        log.debug("Unable to register account.", (Throwable)e);
        return Collections.singletonList(this.errorModelFactory.toError(request, e));
    }

    @Override
    protected void validate(HttpServletRequest request, HttpServletResponse response, Form form) {
        String confirmPassword;
        String password;
        super.validate(request, response, form);
        Field confirmPasswordField = form.getField("confirmPassword");
        if (confirmPasswordField != null && confirmPasswordField.isEnabled() && !(password = form.getFieldValue("password")).equals(confirmPassword = form.getFieldValue("confirmPassword")) && confirmPasswordField.isRequired()) {
            String key = "stormpath.web.register.form.errors.passwordMismatch";
            String msg = this.i18n(request, key);
            throw new MismatchedPasswordException(msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ViewModel onValidSubmit(HttpServletRequest req, HttpServletResponse resp, Form form) throws Exception {
        Account account = (Account)this.client.instantiate(Account.class);
        String value = form.getFieldValue("email");
        if (value != null) {
            account.setEmail(value);
        }
        if ((value = form.getFieldValue("username")) != null) {
            account.setUsername(value);
        }
        if ((value = form.getFieldValue("password")) != null) {
            account.setPassword(value);
        }
        account.setGivenName((value = form.getFieldValue("givenName")) != null ? value : "UNKNOWN");
        value = form.getFieldValue("middleName");
        if (value != null) {
            account.setMiddleName(value);
        }
        account.setSurname((value = form.getFieldValue("surname")) != null ? value : "UNKNOWN");
        account.getCustomData().putAll(this.getCustomData(req, form));
        Application app = ApplicationResolver.INSTANCE.getApplication((ServletRequest)req);
        if (this.preRegisterHandler != null && !this.preRegisterHandler.handle(req, resp, account)) {
            return null;
        }
        AccountStore accountStore = this.accountStoreResolver.getAccountStore(req, resp);
        if (accountStore == null) {
            account = app.createAccount(account);
        } else {
            final Account[] accountHolder = new Account[]{account};
            accountStore.accept((AccountStoreVisitor)new AccountStoreVisitorAdapter(){

                public void visit(Directory directory) {
                    Account createdAccount;
                    accountHolder[0] = createdAccount = directory.createAccount(accountHolder[0]);
                }

                public void visit(Organization organization) {
                    Account createdAccount;
                    accountHolder[0] = createdAccount = organization.createAccount(accountHolder[0]);
                }
            });
            account = accountHolder[0];
        }
        this.publishRequestEvent(new DefaultRegisteredAccountRequestEvent(req, resp, account));
        if (this.postRegisterHandler != null && !this.postRegisterHandler.handle(req, resp, account)) {
            return null;
        }
        AccountStatus status = account.getStatus();
        if (this.isJsonPreferred(req, resp)) {
            return new DefaultViewModel("stormpathJsonView", Collections.singletonMap("account", this.accountModelFactory.toMap(account, Collections.EMPTY_LIST)));
        }
        if (status == AccountStatus.ENABLED) {
            if (!this.autoLogin) return new DefaultViewModel(this.loginUri + "?status=created").setRedirect(true);
            TransientAuthenticationResult result = new TransientAuthenticationResult(account);
            this.authenticationResultSaver.set(req, resp, result);
            return new DefaultViewModel(this.nextUri).setRedirect(true);
        } else {
            if (status != AccountStatus.UNVERIFIED) return new DefaultViewModel(this.nextUri).setRedirect(true);
            return new DefaultViewModel(this.loginUri + "?status=unverified").setRedirect(true);
        }
    }

    private Map<String, Object> getCustomData(HttpServletRequest request, Form form) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Field field : form.getFields()) {
            if (field.getName().equals(this.getCsrfTokenManager().getTokenName()) || ACCOUNT_PROPERTIES.contains(field.getName())) continue;
            result.put(field.getName(), field.getValue());
        }
        Object customData = this.getFieldValueResolver().getAllFields(request).get("customData");
        if (customData instanceof Map) {
            result.putAll((Map)customData);
        }
        return result;
    }
}

