/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Function;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.resource.CollectionResource;
import com.stormpath.sdk.resource.Resource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMapFunction<T extends Resource>
implements Function<T, Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(ResourceMapFunction.class);
    private Collection<String> excludedFields = Collections.emptySet();
    private Collection<String> includedFields = Collections.emptySet();

    public void setExcludedFields(Collection<String> excludedFields) {
        this.excludedFields = excludedFields == null ? Collections.emptySet() : excludedFields;
    }

    public Collection<String> getExcludedFields() {
        return this.excludedFields;
    }

    public Collection<String> getIncludedFields() {
        return this.includedFields;
    }

    public void setIncludedFields(Collection<String> includedFields) {
        this.includedFields = includedFields == null ? Collections.emptySet() : includedFields;
    }

    public Map<String, Object> apply(T t) {
        return this.toMap(t);
    }

    private boolean include(String propName) {
        if (propName.equals("password")) {
            return false;
        }
        if (this.getIncludedFields().contains(propName)) {
            return true;
        }
        return !this.getExcludedFields().contains(propName);
    }

    private boolean include(String propName, Object propValue) {
        if (propName.equals("password")) {
            return false;
        }
        if (this.getIncludedFields().contains(propName)) {
            return true;
        }
        if (this.getExcludedFields().contains(propName)) {
            return false;
        }
        return !(propValue instanceof Resource) || propValue instanceof CustomData;
    }

    public Map<String, Object> toMap(Object o) {
        Assert.notNull((Object)o, (String)"Resource object cannot be null");
        Assert.isInstanceOf(AbstractResource.class, (Object)o, (String)("Object must be an instance of " + AbstractResource.class.getName()));
        AbstractResource resource = (AbstractResource)o;
        if (o instanceof CustomData) {
            CustomData cd = (CustomData)o;
            cd.getCreatedAt();
            return this.deepCopy((Map<String, Object>)((CustomData)o));
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        for (String propName : resource.getPropertyNames()) {
            Object propValue;
            if (!this.include(propName)) continue;
            try {
                Class<?> resourceClass = resource.getClass();
                String methodName = "get" + Strings.capitalize((String)propName);
                Method method = resourceClass.getMethod(methodName, new Class[0]);
                propValue = method.invoke((Object)resource, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                if (!log.isWarnEnabled()) continue;
                String msg = "Unable to access account property '" + propName + "': " + e.getMessage();
                log.warn(msg, (Throwable)e);
                continue;
            }
            if (!this.include(propName, propValue)) continue;
            if (propValue instanceof CollectionResource) {
                CollectionResource collectionResource = (CollectionResource)propValue;
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (Object cr : collectionResource) {
                    Map<String, Object> val = this.toMap(cr);
                    list.add(val);
                }
                propValue = list;
            } else if (propValue instanceof AbstractResource) {
                propValue = this.toMap(propValue);
            }
            props.put(propName, propValue);
        }
        return props;
    }

    private Map<String, Object> deepCopy(Map<String, Object> src) {
        LinkedHashMap<String, Object> dst = new LinkedHashMap<String, Object>();
        for (String name : src.keySet()) {
            Map<String, Object> value = src.get(name);
            if (value instanceof Map) {
                value = this.deepCopy(value);
            } else if (value instanceof Collection) {
                value = this.deepCopy((Collection)((Object)value));
            }
            dst.put(name, value);
        }
        return dst;
    }

    private Collection deepCopy(Collection src) {
        AbstractCollection dst = src instanceof List ? new ArrayList() : new LinkedHashSet();
        for (Object value : src) {
            if (value instanceof Map) {
                value = this.deepCopy((Map)value);
            } else if (value instanceof com.stormpath.sdk.lang.Collections) {
                value = this.deepCopy((Collection)value);
            }
            dst.add(value);
        }
        return dst;
    }
}

